/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.transformer.wire.SerializationWireFormat;
import org.mule.util.FileUtils;
import org.mule.util.UUID;
import org.mule.util.file.DeleteException;
import org.mule.util.queue.QueuePersistenceStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePersistenceStrategy
implements QueuePersistenceStrategy,
MuleContextAware {
    private static final Log logger = LogFactory.getLog(FilePersistenceStrategy.class);
    public static final String DEFAULT_QUEUE_STORE = "queuestore";
    public static final String EXTENSION = ".msg";
    private File store;
    protected MuleContext muleContext;
    private WireFormat serializer;

    public FilePersistenceStrategy(WireFormat serializer) {
        this.serializer = serializer;
    }

    public FilePersistenceStrategy() {
        this(new SerializationWireFormat());
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.serializer.setMuleContext(this.muleContext);
    }

    @Override
    public Object store(String queue, Object obj) throws IOException {
        String id = UUID.getUUID();
        String filename = queue + File.separator + id + EXTENSION;
        File file = FileUtils.newFile(this.store, filename);
        if (!file.getParentFile().exists()) {
            this.createStoreDirectory(file.getParentFile());
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            this.serializer.write(out, obj, this.muleContext.getConfiguration().getDefaultEncoding());
        }
        catch (MuleException e) {
            IOException iox = new IOException();
            iox.initCause(e);
            throw iox;
        }
        finally {
            ((OutputStream)out).close();
        }
        return id;
    }

    protected synchronized void createStoreDirectory(File direcetory) throws IOException {
        if (!direcetory.exists() && !direcetory.mkdirs()) {
            throw new IOException("Failed to create directory: " + direcetory.getAbsolutePath());
        }
    }

    @Override
    public void remove(String queue, Object id) throws IOException {
        String fileName = queue + File.separator + id + EXTENSION;
        File file = FileUtils.newFile(this.store, fileName);
        if (file.exists()) {
            if (!file.delete()) {
                throw new DeleteException(file);
            }
        } else {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
    }

    @Override
    public Object load(String queue, Object id) throws IOException {
        String fileName = queue + File.separator + id + EXTENSION;
        File file = FileUtils.newFile(this.store, fileName);
        FileInputStream in = new FileInputStream(file);
        try {
            Object object = this.serializer.read(in);
            return object;
        }
        catch (MuleException e) {
            IOException iox = new IOException(e.getDetailedMessage());
            iox.initCause(e);
            throw iox;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    @Override
    public List<QueuePersistenceStrategy.Holder> restore() throws IOException {
        ArrayList<QueuePersistenceStrategy.Holder> msgs = new ArrayList<QueuePersistenceStrategy.Holder>();
        if (this.store == null) {
            logger.warn((Object)"No store has be set on the File Persistence Strategy. Not restoring at this time");
            return msgs;
        }
        try {
            this.restoreFiles(this.store, msgs);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Restore retrieved " + msgs.size() + " objects"));
            }
            return msgs;
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("Could not restore").initCause(e);
        }
    }

    protected void restoreFiles(File dir, List<QueuePersistenceStrategy.Holder> msgs) throws IOException, ClassNotFoundException {
        Object[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            if (((File)files[i]).isDirectory()) {
                this.restoreFiles((File)files[i], msgs);
                continue;
            }
            if (!((File)files[i]).getName().endsWith(EXTENSION)) continue;
            String id = ((File)files[i]).getCanonicalPath();
            id = id.substring(this.store.getCanonicalPath().length() + 1, id.length() - EXTENSION.length());
            String queue = id.substring(0, id.indexOf(File.separator));
            id = id.substring(queue.length() + 1);
            msgs.add(new HolderImpl(queue, id));
        }
    }

    @Override
    public void open() throws IOException {
        String path = this.muleContext.getConfiguration().getWorkingDirectory() + File.separator + DEFAULT_QUEUE_STORE;
        this.store = FileUtils.newFile(path).getCanonicalFile();
        if (!this.store.exists()) {
            this.createStoreDirectory(this.store);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    protected static class HolderImpl
    implements QueuePersistenceStrategy.Holder {
        private String queue;
        private Object id;

        public HolderImpl(String queue, Object id) {
            this.queue = queue;
            this.id = id;
        }

        public Object getId() {
            return this.id;
        }

        public String getQueue() {
            return this.queue;
        }
    }
}

