/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.stats.ServiceStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReplyToHandler
implements ReplyToHandler {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private volatile List<Transformer> transformers;
    private final Map<String, ImmutableEndpoint> endpointCache = new HashMap<String, ImmutableEndpoint>();
    protected MuleContext muleContext;

    public DefaultReplyToHandler(List<Transformer> transformers, MuleContext muleContext) {
        this.transformers = transformers;
        this.muleContext = muleContext;
    }

    @Override
    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("sending reply to: " + replyTo));
        }
        String replyToEndpoint = replyTo.toString();
        OutboundEndpoint endpoint = this.getEndpoint(event, replyToEndpoint);
        returnMessage.removeProperty("MULE_REPLYTO");
        returnMessage.removeProperty("MULE_REMOTE_SYNC");
        returnMessage = new DefaultMuleMessage(returnMessage.getPayload(), returnMessage, this.muleContext);
        DefaultMuleEvent replyToEvent = new DefaultMuleEvent(returnMessage, (ImmutableEndpoint)endpoint, event.getSession(), event.getProcessingTime());
        List<String> responseProperties = endpoint.getResponseProperties();
        for (String propertyName : responseProperties) {
            Object propertyValue = event.getMessage().getInboundProperty(propertyName);
            if (propertyValue == null) continue;
            replyToEvent.getMessage().setOutboundProperty(propertyName, propertyValue);
        }
        try {
            ServiceStatistics stats;
            if (event.getFlowConstruct() instanceof Service && (stats = ((Service)event.getFlowConstruct()).getStatistics()).isEnabled()) {
                stats.incSentReplyToEvent();
            }
            endpoint.process(replyToEvent);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("reply to sent: " + endpoint));
            }
        }
        catch (Exception e) {
            throw new DispatchException(CoreMessages.failedToDispatchToReplyto(endpoint), replyToEvent, endpoint, e);
        }
    }

    protected synchronized OutboundEndpoint getEndpoint(MuleEvent event, String endpointUri) throws MuleException {
        OutboundEndpoint endpoint = (OutboundEndpoint)this.endpointCache.get(endpointUri);
        if (endpoint == null) {
            EndpointFactory endpointFactory = this.muleContext.getEndpointFactory();
            EndpointBuilder endpointBuilder = endpointFactory.getEndpointBuilder(endpointUri);
            if (this.transformers == null) {
                endpointBuilder.setTransformers(event.getEndpoint().getResponseTransformers());
            }
            endpoint = endpointFactory.getOutboundEndpoint(endpointBuilder);
            this.endpointCache.put(endpointUri, endpoint);
        }
        return endpoint;
    }

    @Override
    public List<Transformer> getTransformers() {
        return this.transformers;
    }

    @Override
    public void setTransformers(List<Transformer> transformers) {
        this.transformers = transformers;
    }
}

