/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class StringToObjectArray
extends AbstractTransformer {
    private String delimiter = null;
    private static final String DEFAULT_DELIMITER = " ";

    public StringToObjectArray() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.create(Object[].class));
    }

    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        String in = src instanceof byte[] ? this.createStringFromByteArray((byte[])src, outputEncoding) : (src instanceof InputStream ? this.createStringFromInputStream((InputStream)src) : (String)src);
        String[] out = StringUtils.splitAndTrim(in, this.getDelimiter());
        return out;
    }

    protected String createStringFromByteArray(byte[] bytes, String outputEncoding) throws TransformerException {
        try {
            return new String(bytes, outputEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new TransformerException(this, (Throwable)uee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createStringFromInputStream(InputStream input) {
        try {
            String string = IOUtils.toString(input);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public String getDelimiter() {
        if (this.delimiter == null) {
            return DEFAULT_DELIMITER;
        }
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

