/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToBoolean
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public StringToBoolean() {
        this.registerSourceType(new SimpleDataType(String.class));
        this.setReturnDataType(DataTypeFactory.create(Boolean.class));
    }

    @Override
    public Object doTransform(Object src, String encoding) throws TransformerException {
        if (src == null) {
            if (this.isAllowNullReturn()) {
                return null;
            }
            throw new TransformerException(CoreMessages.createStaticMessage("Unable to transform null to a primitive"));
        }
        return Boolean.valueOf((String)src);
    }

    @Override
    public void setReturnDataType(DataType<?> type) {
        if (!Boolean.class.isAssignableFrom(type.getType())) {
            throw new IllegalArgumentException("This transformer only supports Boolean return types.");
        }
        super.setReturnDataType(type);
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

