/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.InputStream;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;

public class StringAppendTransformer
extends AbstractTransformer {
    private String message = "";

    public StringAppendTransformer() {
        this("");
    }

    public StringAppendTransformer(String message) {
        this.message = message;
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.STRING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doTransform(Object src, String encoding) throws TransformerException {
        String string;
        if (src instanceof byte[]) {
            string = new String((byte[])src);
        } else if (src instanceof InputStream) {
            InputStream input = (InputStream)src;
            try {
                string = IOUtils.toString(input);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        } else {
            string = (String)src;
        }
        return StringAppendTransformer.append(this.message, string);
    }

    public static String append(String append, String msg) {
        return msg + append;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

