/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.MessageTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;
import org.mule.util.StringMessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageTransformer
extends AbstractTransformer
implements MessageTransformer {
    @Override
    public boolean isSourceDataTypeSupported(DataType<?> dataType, boolean exactMatch) {
        return super.isSourceDataTypeSupported(dataType, exactMatch) || MuleMessage.class.isAssignableFrom(dataType.getType());
    }

    @Override
    public final Object doTransform(Object src, String enc) throws TransformerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object transform(Object src, String enc) throws TransformerException {
        try {
            return this.transform(src, enc, null);
        }
        catch (TransformerMessagingException e) {
            TransformerException te;
            Throwable cause = e.getCause();
            if (cause instanceof TransformerException && (te = (TransformerException)cause).getTransformer() == this) {
                throw te;
            }
            throw new TransformerException(e.getI18nMessage(), this, (Throwable)e);
        }
    }

    @Override
    public Object transform(Object src, MuleEvent event) throws TransformerMessagingException {
        return this.transform(src, this.getEncoding(src), event);
    }

    @Override
    public final Object transform(Object src, String enc, MuleEvent event) throws TransformerMessagingException {
        Object result;
        MuleMessage message;
        DataType<?> sourceType = DataTypeFactory.create(src.getClass());
        if (!this.isSourceDataTypeSupported(sourceType)) {
            if (this.isIgnoreBadInput()) {
                this.logger.debug((Object)"Source type is incompatible with this transformer and property 'ignoreBadInput' is set to true, so the transformer chain will continue.");
                return src;
            }
            Message msg = CoreMessages.transformOnObjectUnsupportedTypeOfEndpoint(this.getName(), src.getClass(), this.endpoint);
            throw new TransformerMessagingException(msg, event, this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Applying transformer %s (%s)", this.getName(), this.getClass().getName()));
            this.logger.debug((Object)String.format("Object before transform: %s", StringMessageUtils.toString(src)));
        }
        if (src instanceof MuleMessage) {
            message = (MuleMessage)src;
        } else if (this.muleContext.getConfiguration().isAutoWrapMessageAwareTransform()) {
            message = new DefaultMuleMessage(src, this.muleContext);
        } else {
            if (event == null) {
                throw new TransformerMessagingException(CoreMessages.noCurrentEventForTransformer(), event, this);
            }
            message = event.getMessage();
            if (!message.getPayload().equals(src)) {
                throw new IllegalStateException("Transform payload does not match current event");
            }
        }
        try {
            result = this.transformMessage(message, enc);
        }
        catch (TransformerException e) {
            throw new TransformerMessagingException(e.getI18nMessage(), event, this, e);
        }
        if (result == null) {
            result = NullPayload.getInstance();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Object after transform: %s", StringMessageUtils.toString(result)));
        }
        result = this.checkReturnClass(result, event);
        return result;
    }

    protected Object checkReturnClass(Object object, MuleEvent event) throws TransformerMessagingException {
        DataType<?> dt;
        if (object == null || object instanceof NullPayload && this.isAllowNullReturn()) {
            return object;
        }
        if (this.returnType != null && !this.returnType.isCompatibleWith(dt = DataTypeFactory.create(object.getClass()))) {
            throw new TransformerMessagingException(CoreMessages.transformUnexpectedType(dt, this.returnType), event, this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("The transformed object is of expected type. Type is: " + ClassUtils.getSimpleName(object.getClass())));
        }
        return object;
    }

    public abstract Object transformMessage(MuleMessage var1, String var2) throws TransformerException;
}

