/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.security.AbstractAuthenticationFilter;
import org.mule.security.DefaultMuleAuthentication;
import org.mule.security.MuleCredentials;

public class UsernamePasswordAuthenticationFilter
extends AbstractAuthenticationFilter {
    protected static final Log logger = LogFactory.getLog(UsernamePasswordAuthenticationFilter.class);
    private String username = "#[header:inbound:username]";
    private String password = "#[header:inbound:password]";

    public void authenticateInbound(MuleEvent event) throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        Authentication authResult;
        Authentication authentication = this.getAuthenticationToken(event);
        try {
            authResult = this.getSecurityManager().authenticate(authentication);
        }
        catch (UnauthorisedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication request for user: " + this.username + " failed: " + e.toString()));
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser(authentication.getPrincipal().toString()), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        SecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        context.setAuthentication(authResult);
        event.getSession().setSecurityContext(context);
    }

    protected Authentication getAuthenticationToken(MuleEvent event) throws UnauthorisedException {
        ExpressionManager expressionManager = event.getMuleContext().getExpressionManager();
        Object usernameEval = expressionManager.evaluate(this.username, event.getMessage());
        Object passwordEval = expressionManager.evaluate(this.password, event.getMessage());
        if (usernameEval == null) {
            throw new UnauthorisedException(CoreMessages.authNoCredentials());
        }
        if (passwordEval == null) {
            throw new UnauthorisedException(CoreMessages.authNoCredentials());
        }
        return new DefaultMuleAuthentication(new MuleCredentials(usernameEval.toString(), passwordEval.toString().toCharArray()));
    }

    public void authenticateOutbound(MuleEvent event) throws SecurityException, SecurityProviderNotFoundException {
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

