/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.source.MessageSource;
import org.mule.construct.FlowConstructLifecycleManager;
import org.mule.exception.DefaultServiceExceptionStrategy;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.MuleMessageInfoMapping;
import org.mule.util.ClassUtils;

public abstract class AbstractFlowConstruct
implements FlowConstruct,
Lifecycle {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected String name;
    protected MessageSource messageSource;
    protected MessageProcessorChain messageProcessorChain;
    protected MessagingExceptionHandler exceptionListener;
    protected final FlowConstructLifecycleManager lifecycleManager;
    protected final MuleContext muleContext;
    protected FlowConstructStatistics statistics;
    protected MessageInfoMapping messageInfoMapping = new MuleMessageInfoMapping();
    protected ThreadingProfile threadingProfile;

    public AbstractFlowConstruct(String name, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.name = name;
        this.lifecycleManager = new FlowConstructLifecycleManager(this, muleContext);
        this.exceptionListener = new DefaultServiceExceptionStrategy(muleContext);
    }

    public final void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<FlowConstruct>(){

                @Override
                public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                    AbstractFlowConstruct.this.createMessageProcessor();
                    if (AbstractFlowConstruct.this.messageSource != null) {
                        AbstractFlowConstruct.this.messageSource.setListener(new AbstractInterceptingMessageProcessor(){

                            public MuleEvent process(MuleEvent event) throws MuleException {
                                return AbstractFlowConstruct.this.messageProcessorChain.process(event);
                            }
                        });
                    }
                    AbstractFlowConstruct.this.injectFlowConstructMuleContext(AbstractFlowConstruct.this.messageSource);
                    AbstractFlowConstruct.this.injectFlowConstructMuleContext(AbstractFlowConstruct.this.messageProcessorChain);
                    AbstractFlowConstruct.this.injectFlowConstructMuleContext(AbstractFlowConstruct.this.exceptionListener);
                    AbstractFlowConstruct.this.initialiseIfInitialisable(AbstractFlowConstruct.this.messageSource);
                    AbstractFlowConstruct.this.initialiseIfInitialisable(AbstractFlowConstruct.this.messageProcessorChain);
                    AbstractFlowConstruct.this.initialiseIfInitialisable(AbstractFlowConstruct.this.exceptionListener);
                    AbstractFlowConstruct.this.doInitialise();
                    AbstractFlowConstruct.this.validateConstruct();
                }
            });
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public final void start() throws MuleException {
        this.lifecycleManager.fireStartPhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractFlowConstruct.this.startIfStartable(AbstractFlowConstruct.this.messageProcessorChain);
                AbstractFlowConstruct.this.startIfStartable(AbstractFlowConstruct.this.exceptionListener);
                AbstractFlowConstruct.this.startIfStartable(AbstractFlowConstruct.this.messageSource);
                AbstractFlowConstruct.this.doStart();
            }
        });
    }

    public final void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractFlowConstruct.this.stopIfStoppable(AbstractFlowConstruct.this.messageSource);
                AbstractFlowConstruct.this.stopIfStoppable(AbstractFlowConstruct.this.messageProcessorChain);
                AbstractFlowConstruct.this.stopIfStoppable(AbstractFlowConstruct.this.exceptionListener);
                AbstractFlowConstruct.this.doStop();
            }
        });
    }

    public final void dispose() {
        try {
            if (this.isStarted()) {
                this.stop();
            }
            this.lifecycleManager.fireDisposePhase(new LifecycleCallback<FlowConstruct>(){

                @Override
                public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                    AbstractFlowConstruct.this.disposeIfDisposable(AbstractFlowConstruct.this.messageProcessorChain);
                    AbstractFlowConstruct.this.disposeIfDisposable(AbstractFlowConstruct.this.exceptionListener);
                    AbstractFlowConstruct.this.disposeIfDisposable(AbstractFlowConstruct.this.messageSource);
                    AbstractFlowConstruct.this.doDispose();
                }
            });
        }
        catch (MuleException e) {
            this.logger.error((Object)("Failed to stop service: " + this.name), (Throwable)e);
        }
    }

    public ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }

    public boolean isStarted() {
        return this.lifecycleManager.getState().isStarted();
    }

    public boolean isStopped() {
        return this.lifecycleManager.getState().isStopped();
    }

    public boolean isStopping() {
        return this.lifecycleManager.getState().isStopping();
    }

    protected void createMessageProcessor() throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder(this);
        builder.setName("'" + this.getName() + "' processor chain");
        this.configureMessageProcessors(builder);
        this.messageProcessorChain = builder.build();
    }

    protected abstract void configureMessageProcessors(MessageProcessorChainBuilder var1) throws MuleException;

    public String getName() {
        return this.name;
    }

    public MessagingExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public FlowConstructStatistics getStatistics() {
        return this.statistics;
    }

    public MessageInfoMapping getMessageInfoMapping() {
        return this.messageInfoMapping;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }

    protected void doInitialise() throws InitialisationException {
        int threadPoolSize = this.threadingProfile == null ? 0 : this.threadingProfile.getMaxThreadsActive();
        this.statistics = new FlowConstructStatistics(this.getConstructType(), this.name, threadPoolSize);
        this.statistics.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.statistics);
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    protected void doDispose() {
        this.muleContext.getStatistics().remove(this.statistics);
    }

    protected void validateConstruct() throws FlowConstructInvalidException {
    }

    protected void injectFlowConstructMuleContext(Object candidate) {
        if (candidate instanceof FlowConstructAware) {
            ((FlowConstructAware)candidate).setFlowConstruct(this);
        }
        if (candidate instanceof MuleContextAware) {
            ((MuleContextAware)candidate).setMuleContext(this.muleContext);
        }
    }

    public String toString() {
        return String.format("%s{%s}", ClassUtils.getSimpleName(this.getClass()), this.getName());
    }

    protected void initialiseIfInitialisable(Object candidate) throws InitialisationException {
        if (candidate instanceof Initialisable) {
            ((Initialisable)candidate).initialise();
        }
    }

    protected void startIfStartable(Object candidate) throws MuleException {
        if (candidate instanceof Startable) {
            ((Startable)candidate).start();
        }
    }

    protected void stopIfStoppable(Object candidate) throws MuleException {
        if (candidate instanceof Stoppable) {
            ((Stoppable)candidate).stop();
        }
    }

    protected void disposeIfDisposable(Object candidate) {
        if (candidate instanceof Disposable) {
            ((Disposable)candidate).dispose();
        }
    }

    public MessageProcessorChain getMessageProcessorChain() {
        return this.messageProcessorChain;
    }

    public abstract String getConstructType();
}

