/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.processor.policy;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.Predicate;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.policy.AroundPolicy;
import org.mule.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policies {
    private final MessageProcessorChain messageProcessorChain;
    private LinkedList<AroundPolicy> policies = new LinkedList();

    public Policies(MessageProcessorChain messageProcessorChain) {
        this.messageProcessorChain = messageProcessorChain;
    }

    public void add(AroundPolicy policy) {
        if (this.find(policy.getName()) != null) {
            String msg = String.format("There's already a policy registered under name [%s] for chain [%s]:%s", policy.getName(), this.messageProcessorChain.getName(), this.messageProcessorChain);
            throw new IllegalArgumentException(msg);
        }
        this.policies.add(policy);
    }

    public AroundPolicy remove(String policyName) {
        AroundPolicy policy = this.find(policyName);
        if (policy == null) {
            return null;
        }
        this.policies.remove(policy);
        return policy;
    }

    public List<AroundPolicy> list() {
        return Collections.unmodifiableList(this.policies);
    }

    public void clear() {
        this.policies.clear();
    }

    public AroundPolicy find(String policyName) {
        return (AroundPolicy)CollectionUtils.find(this.policies, (Predicate)new BeanPropertyValueEqualsPredicate("name", (Object)policyName));
    }
}

