/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.ResponseOutputStream;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.registry.ServiceType;
import org.mule.api.security.Credentials;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.management.stats.ProcessingTime;
import org.mule.security.MuleCredentials;
import org.mule.session.DefaultMuleSession;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.ObjectNameHelper;
import org.mule.util.UUID;
import org.mule.util.store.DeserializationPostInitialisable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMuleEvent
extends EventObject
implements MuleEvent,
ThreadSafeAccess,
DeserializationPostInitialisable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(DefaultMuleEvent.class);
    private transient ImmutableEndpoint endpoint = null;
    private String id = null;
    private MuleMessage message = null;
    private MuleSession session;
    private boolean stopFurtherProcessing = false;
    private int timeout = Integer.MIN_VALUE;
    private transient ResponseOutputStream outputStream = null;
    private transient Object transformedMessage = null;
    private Credentials credentials = null;
    protected String[] ignoredPropertyOverrides = new String[]{"method"};
    private transient Map<String, Object> serializedData = null;
    private final ProcessingTime processingTime;

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, FlowConstruct service, MuleEvent previousEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = this.generateEventId();
        this.session = previousEvent.getSession();
        this.session.setFlowConstruct(service);
        this.endpoint = endpoint;
        this.timeout = previousEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)previousEvent.getOutputStream();
        this.processingTime = ProcessingTime.newInstance(this.session, message.getMuleContext());
        this.fillProperties();
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleEvent previousEvent, MuleSession session) {
        super(message.getPayload());
        this.message = message;
        this.id = previousEvent.getId();
        this.session = session;
        this.endpoint = endpoint;
        this.timeout = previousEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)previousEvent.getOutputStream();
        this.processingTime = ProcessingTime.newInstance(this.session, message.getMuleContext());
        this.fillProperties();
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleSession session) {
        this(message, endpoint, session, null, null);
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleSession session, ProcessingTime time) {
        this(message, endpoint, session, null, time);
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleSession session, ResponseOutputStream outputStream) {
        this(message, endpoint, session, outputStream, null);
    }

    public DefaultMuleEvent(MuleMessage message, ImmutableEndpoint endpoint, MuleSession session, ResponseOutputStream outputStream, ProcessingTime time) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = this.generateEventId();
        this.outputStream = outputStream;
        this.fillProperties();
        this.processingTime = time != null ? time : ProcessingTime.newInstance(this.session, message.getMuleContext());
    }

    public DefaultMuleEvent(MuleMessage message, MuleEvent rewriteEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = rewriteEvent.getId();
        this.session = rewriteEvent.getSession();
        this.session.setFlowConstruct(rewriteEvent.getFlowConstruct());
        this.endpoint = rewriteEvent.getEndpoint();
        this.timeout = rewriteEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)rewriteEvent.getOutputStream();
        if (rewriteEvent instanceof DefaultMuleEvent) {
            this.transformedMessage = ((DefaultMuleEvent)rewriteEvent).getCachedMessage();
            this.processingTime = ((DefaultMuleEvent)rewriteEvent).processingTime;
        } else {
            this.processingTime = ProcessingTime.newInstance(this.session, message.getMuleContext());
        }
        this.fillProperties();
    }

    protected void fillProperties() {
        if (this.endpoint != null && this.endpoint.getProperties() != null) {
            for (String prop : this.endpoint.getProperties().keySet()) {
                Object value = this.endpoint.getProperties().get(prop);
                if (this.ignoreProperty(prop)) continue;
                this.message.setInvocationProperty(prop, value);
            }
        }
        this.setCredentials();
    }

    protected boolean ignoreProperty(String key) {
        if (key == null) {
            return true;
        }
        for (int i = 0; i < this.ignoredPropertyOverrides.length; ++i) {
            if (!key.equals(this.ignoredPropertyOverrides[i])) continue;
            return false;
        }
        return null != this.message.getOutboundProperty(key);
    }

    protected void setCredentials() {
        if (null != this.endpoint && null != this.endpoint.getEndpointURI() && null != this.endpoint.getEndpointURI().getUserInfo()) {
            String userName = this.endpoint.getEndpointURI().getUser();
            String password = this.endpoint.getEndpointURI().getPassword();
            if (password != null && userName != null) {
                this.credentials = new MuleCredentials(userName, password.toCharArray());
            }
        }
    }

    @Override
    public Credentials getCredentials() {
        MuleCredentials creds = (MuleCredentials)this.message.getOutboundProperty("MULE_CREDENTIALS");
        return this.credentials != null ? this.credentials : creds;
    }

    Object getCachedMessage() {
        return this.transformedMessage;
    }

    @Override
    public MuleMessage getMessage() {
        return this.message;
    }

    @Override
    public byte[] getMessageAsBytes() throws DefaultMuleException {
        try {
            return this.message.getPayloadAsBytes();
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsBytes(this.message.getPayload().getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public <T> T transformMessage(Class<T> outputType) throws TransformerException {
        return this.transformMessage(DataTypeFactory.create(outputType));
    }

    @Override
    public <T> T transformMessage(DataType<T> outputType) throws TransformerException {
        if (outputType == null) {
            throw new TransformerException(CoreMessages.objectIsNull("outputType"));
        }
        return this.message.getPayload(outputType);
    }

    @Override
    @Deprecated
    public byte[] transformMessageToBytes() throws TransformerException {
        return this.transformMessage(DataType.BYTE_ARRAY_DATA_TYPE);
    }

    @Override
    public String transformMessageToString() throws TransformerException {
        return this.transformMessage(DataTypeFactory.createWithEncoding(String.class, this.getEncoding()));
    }

    @Override
    public String getMessageAsString() throws MuleException {
        return this.getMessageAsString(this.getEncoding());
    }

    @Override
    public String getMessageAsString(String encoding) throws MuleException {
        try {
            return this.message.getPayloadForLogging(encoding);
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsString(this.message.getClass().getName()), (Throwable)e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Deprecated
    public Object getProperty(String name) {
        throw new UnsupportedOperationException("Method's behavior has changed in Mule 3, use event.getMessage() and suitable scope-aware property access methods on it");
    }

    @Override
    @Deprecated
    public Object getProperty(String name, Object defaultValue) {
        throw new UnsupportedOperationException("Method's behavior has changed in Mule 3, use event.getMessage() and suitable scope-aware property access methods on it");
    }

    @Override
    public ImmutableEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("MuleEvent: ").append(this.getId());
        buf.append(", stop processing=").append(this.isStopFurtherProcessing());
        buf.append(", ").append(this.endpoint);
        return buf.toString();
    }

    protected String generateEventId() {
        return UUID.getUUID();
    }

    @Override
    public MuleSession getSession() {
        return this.session;
    }

    void setSession(MuleSession session) {
        this.session = session;
    }

    @Override
    public FlowConstruct getFlowConstruct() {
        return this.session.getFlowConstruct();
    }

    @Override
    public boolean isStopFurtherProcessing() {
        return this.stopFurtherProcessing;
    }

    @Override
    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.stopFurtherProcessing = stopFurtherProcessing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMuleEvent)) {
            return false;
        }
        DefaultMuleEvent event = (DefaultMuleEvent)o;
        if (this.message != null ? !this.message.equals(event.message) : event.message != null) {
            return false;
        }
        return this.id.equals(event.id);
    }

    public int hashCode() {
        return 29 * this.id.hashCode() + (this.message != null ? this.message.hashCode() : 0);
    }

    @Override
    public int getTimeout() {
        if (this.timeout == Integer.MIN_VALUE) {
            this.timeout = this.endpoint.getResponseTimeout();
        }
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.endpoint.hashCode());
        out.writeBoolean(this.endpoint instanceof InboundEndpoint);
        out.writeObject(this.endpoint.getEndpointBuilderName());
        String uri = this.endpoint.getEndpointURI().getUri().toString();
        if (ObjectNameHelper.isDefaultAutoGeneratedConnector(this.endpoint.getConnector())) {
            out.writeObject(uri);
        } else {
            out.writeObject(uri + "?connector=" + this.endpoint.getConnector().getName());
        }
        out.writeInt(this.endpoint.getTransformers().size());
        if (this.endpoint.getTransformers().size() > 0) {
            for (Transformer transformer : this.endpoint.getTransformers()) {
                out.writeObject(transformer.getName());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, MuleException {
        in.defaultReadObject();
        this.serializedData = new HashMap<String, Object>();
        this.serializedData.put("endpointHashcode", in.readInt());
        this.serializedData.put("isInboundEndpoint", in.readBoolean());
        this.serializedData.put("endpointBuilderName", in.readObject());
        this.serializedData.put("endpointUri", in.readObject());
        int count = in.readInt();
        LinkedList<String> transformerNames = new LinkedList<String>();
        if (count > 0) {
            while (--count > 0) {
                transformerNames.add((String)in.readObject());
            }
        }
        this.serializedData.put("transformers", transformerNames);
    }

    private void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
        if (this.session instanceof DefaultMuleSession) {
            ((DefaultMuleSession)this.session).initAfterDeserialisation(muleContext);
        }
        if (this.message instanceof DefaultMuleMessage) {
            ((DefaultMuleMessage)this.message).initAfterDeserialisation(muleContext);
        }
        int endpointHashcode = (Integer)this.serializedData.get("endpointHashcode");
        boolean isInboundEndpoint = (Boolean)this.serializedData.get("isInboundEndpoint");
        String endpointBuilderName = (String)this.serializedData.get("endpointBuilderName");
        String endpointUri = (String)this.serializedData.get("endpointUri");
        List transformerNames = (List)this.serializedData.get("transformers");
        this.endpoint = (ImmutableEndpoint)muleContext.getRegistry().lookupObject("endpoint:" + endpointHashcode);
        if (this.endpoint == null) {
            if (endpointBuilderName != null && muleContext.getRegistry().lookupEndpointBuilder(endpointBuilderName) != null) {
                this.endpoint = isInboundEndpoint ? muleContext.getEndpointFactory().getInboundEndpoint(endpointBuilderName) : muleContext.getEndpointFactory().getOutboundEndpoint(endpointBuilderName);
            } else {
                LinkedList<Transformer> transformers = new LinkedList<Transformer>();
                for (String name : transformerNames) {
                    Transformer next = muleContext.getRegistry().lookupTransformer(name);
                    if (next == null) {
                        throw new IllegalStateException(CoreMessages.objectNotFound(name).toString());
                    }
                    transformers.add(next);
                }
                MuleEndpointURI uri = new MuleEndpointURI(endpointUri, muleContext);
                TransportServiceDescriptor tsd = (TransportServiceDescriptor)muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, uri.getFullScheme(), null);
                EndpointBuilder endpointBuilder = tsd.createEndpointBuilder(endpointUri);
                endpointBuilder.setTransformers(transformers);
                this.endpoint = isInboundEndpoint ? muleContext.getEndpointFactory().getInboundEndpoint(endpointBuilder) : muleContext.getEndpointFactory().getOutboundEndpoint(endpointBuilder);
            }
        }
        this.serializedData = null;
    }

    @Override
    public String getEncoding() {
        String encoding = this.message.getEncoding();
        if (encoding == null) {
            encoding = this.endpoint.getEncoding();
        }
        return encoding;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.message.getMuleContext();
    }

    @Override
    public ThreadSafeAccess newThreadCopy() {
        if (this.message instanceof ThreadSafeAccess) {
            DefaultMuleEvent copy = new DefaultMuleEvent((MuleMessage)((Object)((ThreadSafeAccess)((Object)this.message)).newThreadCopy()), this);
            copy.resetAccessControl();
            return copy;
        }
        return this;
    }

    @Override
    public void resetAccessControl() {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).resetAccessControl();
        }
    }

    @Override
    public void assertAccess(boolean write) {
        if (this.message instanceof ThreadSafeAccess) {
            ((ThreadSafeAccess)((Object)this.message)).assertAccess(write);
        }
    }

    @Override
    @Deprecated
    public Object transformMessage() throws TransformerException {
        logger.warn((Object)"Deprecation warning: MuleEvent.transformMessage does nothing in Mule 3.x.  The message is already transformed before the event reaches a component");
        return this.message.getPayload();
    }

    @Override
    public ProcessingTime getProcessingTime() {
        return this.processingTime;
    }
}

