/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.text.NumberFormat;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;

public class NumberToString
extends AbstractTransformer
implements DiscoverableTransformer {
    private NumberFormat numberFormat;
    private int priorityWeighting = 2;

    public NumberToString() {
        this.registerSourceType(new SimpleDataType(Number.class));
        this.setReturnDataType(DataTypeFactory.STRING);
    }

    public NumberToString(NumberFormat numberFormat) {
        this();
        this.numberFormat = numberFormat;
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        if (src == null) {
            return "";
        }
        if (this.numberFormat != null) {
            return this.numberFormat.format(src);
        }
        return ((Number)src).toString();
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

