/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.InputStream;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class ByteArrayToHexString
extends AbstractTransformer {
    private volatile boolean upperCase = false;

    public ByteArrayToHexString() {
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.TEXT_STRING);
    }

    public boolean getUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean value) {
        this.upperCase = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doTransform(Object src, String encoding) throws TransformerException {
        if (src == null) {
            return "";
        }
        try {
            byte[] bytes = null;
            if (src instanceof InputStream) {
                InputStream input = (InputStream)src;
                try {
                    bytes = IOUtils.toByteArray(input);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
            } else {
                bytes = (byte[])src;
            }
            return StringUtils.toHexString(bytes, this.upperCase);
        }
        catch (Exception ex) {
            throw new TransformerException(this, (Throwable)ex);
        }
    }
}

