/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RouterStatisticsRecorder;
import org.mule.api.source.MessageSource;
import org.mule.management.stats.RouterStatistics;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.StopFurtherMessageProcessingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.routing.MessageFilter;
import org.mule.source.StartableCompositeMessageSource;
import org.mule.util.StringMessageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceCompositeMessageSource
extends StartableCompositeMessageSource
implements Initialisable,
RouterStatisticsRecorder {
    protected List<MessageProcessor> processors = new LinkedList<MessageProcessor>();
    protected RouterStatistics statistics;
    protected List<InboundEndpoint> endpoints = new ArrayList<InboundEndpoint>();
    protected MessageProcessor catchAllStrategy;
    private final InterceptingMessageProcessor internalCatchAllStrategy = new InternalCatchAllMessageProcessor();

    public ServiceCompositeMessageSource() {
        this.statistics = new RouterStatistics(1);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.catchAllStrategy != null) {
            for (MessageProcessor processor : this.processors) {
                if (!(processor instanceof MessageFilter) || ((MessageFilter)processor).getUnacceptedMessageProcessor() != null) continue;
                ((MessageFilter)processor).setUnacceptedMessageProcessor(this.catchAllStrategy);
            }
        }
        try {
            this.createMessageProcessorChain();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof FlowConstructAware)) continue;
            ((FlowConstructAware)((Object)processor)).setFlowConstruct(this.flowConstruct);
        }
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof Initialisable)) continue;
            ((Initialisable)((Object)processor)).initialise();
        }
    }

    @Override
    public void dispose() {
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof Disposable)) continue;
            ((Disposable)((Object)processor)).dispose();
        }
        super.dispose();
    }

    protected void createMessageProcessorChain() throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder(this.flowConstruct);
        builder.chain(this.processors);
        builder.chain(new StopFurtherMessageProcessingMessageProcessor());
        builder.chain(new AbstractInterceptingMessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                if (ServiceCompositeMessageSource.this.getRouterStatistics().isEnabled()) {
                    ServiceCompositeMessageSource.this.getRouterStatistics().incrementRoutedMessage(event.getEndpoint());
                }
                return this.processNext(event);
            }
        });
        builder.chain(this.listener);
        this.listener = builder.build();
    }

    @Override
    public void start() throws MuleException {
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof Startable)) continue;
            ((Startable)((Object)processor)).start();
        }
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        super.stop();
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof Stoppable)) continue;
            ((Stoppable)((Object)processor)).stop();
        }
    }

    public void setMessageProcessors(List<MessageProcessor> processors) {
        this.processors = processors;
    }

    public void addMessageProcessor(MessageProcessor processor) {
        this.processors.add(processor);
    }

    @Override
    public void addSource(MessageSource source) throws MuleException {
        super.addSource(source);
        if (source instanceof InboundEndpoint) {
            this.endpoints.add((InboundEndpoint)source);
        }
    }

    @Override
    public void removeSource(MessageSource source) throws MuleException {
        super.removeSource(source);
        if (source instanceof InboundEndpoint) {
            this.endpoints.remove(source);
        }
    }

    @Override
    public void setMessageSources(List<MessageSource> sources) throws MuleException {
        this.endpoints.clear();
        super.setMessageSources(sources);
    }

    public List<InboundEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.processors;
    }

    public RouterStatistics getRouterStatistics() {
        return this.statistics;
    }

    @Override
    public void setRouterStatistics(RouterStatistics statistics) {
        this.statistics = statistics;
    }

    public InboundEndpoint getEndpoint(String name) {
        for (InboundEndpoint endpoint : this.endpoints) {
            if (!endpoint.getName().equals(name)) continue;
            return endpoint;
        }
        return null;
    }

    public void setCatchAllStrategy(MessageProcessor catchAllStrategy) {
        if (catchAllStrategy instanceof AbstractCatchAllStrategy) {
            ((AbstractCatchAllStrategy)catchAllStrategy).setRouterStatistics(this.statistics);
        }
        this.catchAllStrategy = catchAllStrategy;
        this.internalCatchAllStrategy.setListener(catchAllStrategy);
    }

    public MessageProcessor getCatchAllStrategy() {
        return this.catchAllStrategy;
    }

    class InternalCatchAllMessageProcessor
    extends AbstractInterceptingMessageProcessor {
        InternalCatchAllMessageProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            if (ServiceCompositeMessageSource.this.getRouterStatistics().isEnabled()) {
                ServiceCompositeMessageSource.this.getRouterStatistics().incrementNoRoutedMessage();
            }
            if (this.next != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Message did not match any routers on: " + event.getFlowConstruct().getName() + " - invoking catch all strategy"));
                }
                if (ServiceCompositeMessageSource.this.getRouterStatistics().isEnabled()) {
                    ServiceCompositeMessageSource.this.getRouterStatistics().incrementCaughtMessage();
                }
                return this.processNext(event);
            }
            this.logger.warn((Object)("Message did not match any routers on: " + event.getFlowConstruct().getName() + " and there is no catch all strategy configured on this router.  Disposing message: " + event));
            if (this.logger.isDebugEnabled()) {
                try {
                    this.logger.warn((Object)("Message fragment is: " + StringMessageUtils.truncate(event.getMessageAsString(), 100, true)));
                }
                catch (MuleException muleException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

