/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.correlation;

import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.routing.AggregationException;
import org.mule.routing.EventGroup;
import org.mule.routing.correlation.EventCorrelatorCallback;

public class CollectionCorrelatorCallback
implements EventCorrelatorCallback {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleContext muleContext;

    public CollectionCorrelatorCallback(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public MuleEvent aggregateEvents(EventGroup events) throws AggregationException {
        return events.getMessageCollectionEvent();
    }

    public EventGroup createEventGroup(MuleEvent event, Object groupId) {
        return new EventGroup(groupId, event.getMessage().getCorrelationGroupSize());
    }

    public boolean shouldAggregateEvents(EventGroup events) {
        int size = events.expectedSize();
        if (size == -1) {
            this.logger.warn((Object)"Correlation Group Size not set, but correlation aggregator is being used. Message is being forwarded as is");
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormat.format("Correlation group size is {0}. Current event group size is {1} for group ID: {2}", size, events.size(), events.getGroupId()));
        }
        return size == events.size();
    }
}

