/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityFilter;
import org.mule.config.ExceptionHelper;
import org.mule.context.notification.SecurityNotification;
import org.mule.endpoint.EndpointAware;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transport.AbstractConnector;

public class SecurityFilterMessageProcessor
extends AbstractInterceptingMessageProcessor
implements EndpointAware {
    private SecurityFilter filter;

    public SecurityFilterMessageProcessor() {
    }

    public SecurityFilterMessageProcessor(SecurityFilter filter) {
        this.filter = filter;
    }

    public SecurityFilter getFilter() {
        return this.filter;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.filter != null) {
            try {
                this.filter.doFilter(event);
            }
            catch (SecurityException e) {
                e = (SecurityException)ExceptionHelper.sanitizeIfNeeded(e);
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                AbstractConnector connector = (AbstractConnector)event.getEndpoint().getConnector();
                connector.fireNotification(new SecurityNotification(e, 401));
                event.getFlowConstruct().getExceptionListener().handleException(e, event);
                event.getMessage().setPayload(e.getLocalizedMessage());
                event.getMessage().setExceptionPayload(new DefaultExceptionPayload(e));
                return event;
            }
        }
        return this.processNext(event);
    }

    public void setFilter(SecurityFilter filter) {
        this.filter = filter;
    }

    public void setEndpoint(ImmutableEndpoint ep) {
        if (this.filter instanceof EndpointAware) {
            ((EndpointAware)((Object)this.filter)).setEndpoint(ep);
        }
    }
}

