/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointCache;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;

public class SimpleEndpointCache
implements EndpointCache {
    protected MuleContext muleContext;
    private ConcurrentMap inboundEndpointCache = new ConcurrentHashMap();
    private ConcurrentMap outboundEndpointCache = new ConcurrentHashMap();

    public SimpleEndpointCache(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public OutboundEndpoint getOutboundEndpoint(String uri, MessageExchangePattern mep, Long responseTimeout) throws MuleException {
        OutboundEndpoint endpoint = (OutboundEndpoint)this.outboundEndpointCache.get((Object)(uri + ":" + mep.toString() + ":" + responseTimeout));
        if (endpoint == null) {
            EndpointBuilder endpointBuilder = this.muleContext.getRegistry().lookupEndpointFactory().getEndpointBuilder(uri);
            endpointBuilder.setExchangePattern(mep);
            if (responseTimeout != null && responseTimeout > 0L) {
                endpointBuilder.setResponseTimeout(responseTimeout.intValue());
            }
            endpoint = this.muleContext.getEndpointFactory().getOutboundEndpoint(endpointBuilder);
            OutboundEndpoint concurrentlyAddedEndpoint = (OutboundEndpoint)this.outboundEndpointCache.putIfAbsent((Object)(uri + ":" + mep.toString() + ":" + responseTimeout), (Object)endpoint);
            if (concurrentlyAddedEndpoint != null) {
                return concurrentlyAddedEndpoint;
            }
        }
        return endpoint;
    }

    public InboundEndpoint getInboundEndpoint(String uri, MessageExchangePattern mep) throws MuleException {
        InboundEndpoint endpoint = (InboundEndpoint)this.inboundEndpointCache.get((Object)(uri + ":" + mep.toString()));
        if (endpoint == null) {
            EndpointBuilder endpointBuilder = this.muleContext.getRegistry().lookupEndpointFactory().getEndpointBuilder(uri);
            endpointBuilder.setExchangePattern(mep);
            endpoint = this.muleContext.getEndpointFactory().getInboundEndpoint(endpointBuilder);
            InboundEndpoint concurrentlyAddedEndpoint = (InboundEndpoint)this.inboundEndpointCache.putIfAbsent((Object)(uri + ":" + mep.toString()), (Object)endpoint);
            if (concurrentlyAddedEndpoint != null) {
                return concurrentlyAddedEndpoint;
            }
        }
        return endpoint;
    }
}

