/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.net.URI;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.endpoint.AbstractEndpointURIBuilder;

public class ResourceNameEndpointURIBuilder
extends AbstractEndpointURIBuilder {
    protected static final Log logger = LogFactory.getLog(ResourceNameEndpointURIBuilder.class);
    public static final String RESOURCE_INFO_PROPERTY = "resourceInfo";

    protected void setEndpoint(URI uri, Properties props) throws MalformedEndpointException {
        int x;
        this.address = "";
        String host = uri.getHost();
        if (host != null && !"localhost".equals(host)) {
            this.address = host;
        }
        String path = uri.getPath();
        String authority = uri.getAuthority();
        if (path != null && path.length() != 0) {
            if (this.address.length() > 0) {
                this.address = this.address + "/";
            }
            this.address = this.address + path.substring(1);
        } else if (authority != null && !authority.equals(this.address)) {
            this.address = this.address + authority;
            int atCharIndex = -1;
            if (this.address != null && this.address.length() != 0 && (atCharIndex = this.address.indexOf("@")) > -1) {
                this.userInfo = this.address.substring(0, atCharIndex);
                this.address = this.address.substring(atCharIndex + 1);
            }
        }
        int y = this.address.indexOf("@");
        if (y > -1) {
            this.userInfo = this.address.substring(0, y);
        }
        ++y;
        String credentials = uri.getUserInfo();
        if (credentials != null && credentials.length() != 0) {
            this.userInfo = credentials;
        }
        if ((x = this.address.indexOf(":", y)) > -1) {
            String resourceInfo = this.address.substring(y, x);
            props.setProperty(RESOURCE_INFO_PROPERTY, resourceInfo);
            this.address = this.address.substring(x + 1);
        }
    }
}

