/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.StringUtils;

public class ObjectArrayToString
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;
    private static final String DEFAULT_DELIMITER = " ";
    private String delimiter = null;

    public ObjectArrayToString() {
        this.registerSourceType(DataTypeFactory.create(Object[].class));
        this.setReturnDataType(DataTypeFactory.TEXT_STRING);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        if (src == null) {
            return src;
        }
        Object[] in = (Object[])src;
        String out = StringUtils.join((Object[])in, (String)this.getDelimiter());
        return out;
    }

    public String getDelimiter() {
        if (this.delimiter == null) {
            return DEFAULT_DELIMITER;
        }
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

