/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.Arrays;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.SimpleFlowConstruct;
import org.mule.processor.chain.AbstractMessageProcessorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageProcessorChain
extends AbstractMessageProcessorChain {
    public DefaultMessageProcessorChain(List<MessageProcessor> processors) {
        super(null, processors);
    }

    public DefaultMessageProcessorChain(MessageProcessor ... processors) {
        super(null, Arrays.asList(processors));
    }

    public DefaultMessageProcessorChain(String name, List<MessageProcessor> processors) {
        super(name, processors);
    }

    public DefaultMessageProcessorChain(String name, MessageProcessor ... processors) {
        super(name, Arrays.asList(processors));
    }

    @Override
    protected MuleEvent doProcess(MuleEvent event) throws MuleException {
        FlowConstruct flowConstruct = event.getFlowConstruct();
        MuleEvent currentEvent = event;
        for (MessageProcessor processor : this.processors) {
            MuleEvent resultEvent;
            if (processor instanceof OutboundEndpoint) {
                currentEvent = new DefaultMuleEvent(currentEvent.getMessage(), (OutboundEndpoint)processor, currentEvent.getSession());
            }
            if ((resultEvent = processor.process(currentEvent)) != null) {
                currentEvent = resultEvent;
                continue;
            }
            if (flowConstruct instanceof SimpleFlowConstruct) {
                currentEvent = OptimizedRequestContext.criticalSetEvent(currentEvent);
                continue;
            }
            return null;
        }
        return currentEvent;
    }
}

