/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.resolvers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.api.model.EntryPointResolver;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.resolvers.CallableEntryPointResolver;
import org.mule.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.model.resolvers.MethodHeaderPropertyEntryPointResolver;
import org.mule.model.resolvers.ReflectionEntryPointResolver;
import org.mule.util.ClassUtils;

public class LegacyEntryPointResolverSet
extends DefaultEntryPointResolverSet {
    private static final String ANNOTATED_ENTRYPOINT_RESOLVER_CLASS = "org.mule.impl.model.resolvers.AnnotatedEntryPointResolver";
    private static final Log logger = LogFactory.getLog(LegacyEntryPointResolverSet.class);

    public LegacyEntryPointResolverSet() {
        this.addAnnotatedEntryPointResolver();
        this.addEntryPointResolver(new MethodHeaderPropertyEntryPointResolver());
        this.addEntryPointResolver(new CallableEntryPointResolver());
        ReflectionEntryPointResolver reflectionResolver = new ReflectionEntryPointResolver();
        reflectionResolver.removeIgnoredMethod("set*");
        this.addEntryPointResolver(reflectionResolver);
    }

    protected void addAnnotatedEntryPointResolver() {
        try {
            Class<EntryPointResolver> annotatedEntrypointResolver = ClassUtils.loadClass(ANNOTATED_ENTRYPOINT_RESOLVER_CLASS, this.getClass(), EntryPointResolver.class);
            this.addEntryPointResolver(ClassUtils.instanciateClass(annotatedEntrypointResolver, ClassUtils.NO_ARGS));
        }
        catch (ClassNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.warn((Object)"Mule annotations module is not on your classpath, annotations cannot be used on components");
            }
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.cannotLoadFromClasspath(ANNOTATED_ENTRYPOINT_RESOLVER_CLASS));
        }
    }
}

