/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression.transformers;

import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.ExpressionConfig;
import org.mule.transformer.types.DataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionArgument
implements MuleContextAware {
    private ExpressionConfig expressionConfig = new ExpressionConfig();
    private String name;
    private boolean optional;
    private Class<?> returnClass;
    protected ClassLoader expressionEvaluationClassLoader = ExpressionArgument.class.getClassLoader();
    private MuleContext muleContext;

    public ExpressionArgument() {
    }

    public ExpressionArgument(String name, ExpressionConfig expressionConfig, boolean optional) {
        this(name, expressionConfig, optional, null);
    }

    public ExpressionArgument(String name, ExpressionConfig expressionConfig, boolean optional, Class<?> returnClass) {
        this.expressionConfig = expressionConfig;
        this.name = name;
        this.optional = optional;
        this.returnClass = returnClass;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExpressionConfig getExpressionConfig() {
        return this.expressionConfig;
    }

    public void setExpressionConfig(ExpressionConfig expressionConfig) {
        this.expressionConfig = expressionConfig;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    protected String getFullExpression() {
        return this.expressionConfig.getFullExpression(this.muleContext.getExpressionManager());
    }

    protected void validate() {
        this.expressionConfig.validate(this.muleContext.getExpressionManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(MuleMessage message) throws ExpressionRuntimeException {
        Object result = null;
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.expressionEvaluationClassLoader);
            result = this.muleContext.getExpressionManager().evaluate(this.getExpression(), this.getEvaluator(), message, !this.isOptional());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
        if (this.getReturnClass() != null && result != null && !this.getReturnClass().isInstance(result)) {
            try {
                Transformer t = this.muleContext.getRegistry().lookupTransformer(DataTypeFactory.createFromObject(result), DataTypeFactory.create(this.getReturnClass()));
                result = t.transform(result);
            }
            catch (TransformerException e) {
                throw new ExpressionRuntimeException(CoreMessages.transformUnexpectedType(result.getClass(), this.getReturnClass()), (Throwable)e);
            }
        }
        return result;
    }

    public String getExpression() {
        return this.expressionConfig.getExpression();
    }

    public void setExpression(String expression) {
        this.expressionConfig.setExpression(expression);
    }

    public String getEvaluator() {
        return this.expressionConfig.getEvaluator();
    }

    public void setEvaluator(String evaluator) {
        this.expressionConfig.setEvaluator(evaluator);
    }

    public void setCustomEvaluator(String evaluator) {
        this.expressionConfig.setCustomEvaluator(evaluator);
    }

    public String getCustomEvaluator() {
        return this.expressionConfig.getCustomEvaluator();
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public void setReturnDataType(Class<?> returnClass) {
        this.returnClass = returnClass;
    }

    public void setExpressionEvaluationClassLoader(ClassLoader expressionEvaluationClassLoader) {
        this.expressionEvaluationClassLoader = expressionEvaluationClassLoader;
    }
}

