/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import java.lang.reflect.InvocationTargetException;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.transport.Connectable;
import org.mule.context.notification.ExceptionNotification;
import org.mule.exception.AbstractExceptionListener;
import org.mule.message.DefaultExceptionPayload;
import org.mule.transport.ConnectException;

public class DefaultSystemExceptionStrategy
extends AbstractExceptionListener
implements SystemExceptionHandler {
    public DefaultSystemExceptionStrategy() {
    }

    public DefaultSystemExceptionStrategy(MuleContext muleContext) {
        this.setMuleContext(muleContext);
    }

    public void handleException(Exception e) {
        Connectable connectable = null;
        if (e instanceof InvocationTargetException) {
            Throwable t = e.getCause();
            Exception exception = e = t instanceof Exception ? (Exception)t : new Exception(t);
        }
        if (this.enableNotifications) {
            this.fireNotification(new ExceptionNotification(e));
        }
        if (e instanceof ConnectException) {
            this.logger.info((Object)"Exception caught is a ConnectException, attempting to reconnect...");
            connectable = ((ConnectException)e).getFailed();
            try {
                this.logger.debug((Object)("Disconnecting " + connectable.getClass().getName()));
                connectable.disconnect();
            }
            catch (Exception e1) {
                this.logger.error((Object)e1.getMessage());
            }
        }
        this.logException(e);
        this.handleTransaction(e);
        if (RequestContext.getEvent() != null) {
            RequestContext.setExceptionPayload(new DefaultExceptionPayload(e));
        }
        if (connectable != null) {
            try {
                this.logger.debug((Object)("Reconnecting " + connectable.getClass().getName()));
                connectable.connect();
            }
            catch (Exception e2) {
                this.logger.error((Object)e2.getMessage());
            }
        }
    }
}

