/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.service.Service;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.api.transport.DispatchException;
import org.mule.api.util.StreamCloserService;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.ExceptionNotification;
import org.mule.message.ExceptionMessage;
import org.mule.processor.AbstractMessageProcessorOwner;
import org.mule.routing.filters.WildcardFilter;
import org.mule.routing.outbound.MulticastingRouter;
import org.mule.session.DefaultMuleSession;
import org.mule.transaction.TransactionCoordination;
import org.mule.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExceptionListener
extends AbstractMessageProcessorOwner {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List<MessageProcessor> messageProcessors = new CopyOnWriteArrayList<MessageProcessor>();
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected WildcardFilter rollbackTxFilter;
    protected WildcardFilter commitTxFilter;
    protected boolean enableNotifications = true;

    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public void setMessageProcessors(List<MessageProcessor> processors) {
        if (processors == null) {
            throw new IllegalArgumentException("List of targets = null");
        }
        this.messageProcessors.clear();
        this.messageProcessors.addAll(processors);
    }

    public void addEndpoint(MessageProcessor processor) {
        if (processor != null) {
            this.messageProcessors.add(processor);
        }
    }

    public boolean removeMessageProcessor(MessageProcessor processor) {
        return this.messageProcessors.remove(processor);
    }

    protected Throwable getExceptionType(Throwable t, Class exceptionType) {
        while (t != null) {
            if (exceptionType.isAssignableFrom(t.getClass())) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    @Override
    public final synchronized void initialise() throws InitialisationException {
        super.initialise();
        if (!this.initialised.get()) {
            this.doInitialise(this.muleContext);
            this.initialised.set(true);
        }
    }

    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        this.logger.info((Object)("Initialising exception listener: " + this.toString()));
    }

    protected void handleTransaction(Throwable t) {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx == null) {
            return;
        }
        t = ExceptionHelper.getRootException(t);
        if (this.rollbackTxFilter == null && this.commitTxFilter == null) {
            this.rollbackTransaction();
        } else if (this.rollbackTxFilter != null && this.rollbackTxFilter.accept(t.getClass().getName())) {
            this.rollbackTransaction();
        } else if (this.commitTxFilter != null && !this.commitTxFilter.accept(t.getClass().getName())) {
            this.rollbackTransaction();
        }
    }

    protected void rollbackTransaction() {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (TransactionException e) {
            this.logException(e);
        }
    }

    protected void routeException(MuleMessage message, MessageProcessor target, Throwable t) {
        block9: {
            List<MessageProcessor> endpoints = this.getMessageProcessors(t);
            if (CollectionUtils.isNotEmpty(endpoints)) {
                try {
                    this.logger.error((Object)("Message being processed is: " + (message == null ? "null" : message.toString())));
                    MuleEventContext ctx = RequestContext.getEventContext();
                    String component = "Unknown";
                    EndpointURI endpointUri = null;
                    if (ctx != null) {
                        if (ctx.getFlowConstruct() != null) {
                            component = ctx.getFlowConstruct().getName();
                        }
                        endpointUri = ctx.getEndpointURI();
                    } else if (target instanceof ImmutableEndpoint) {
                        endpointUri = ((ImmutableEndpoint)((Object)target)).getEndpointURI();
                    }
                    ExceptionMessage msg = new ExceptionMessage(message.getPayload(), t, component, endpointUri);
                    DefaultMuleMessage exceptionMessage = ctx == null ? new DefaultMuleMessage(msg, this.muleContext) : new DefaultMuleMessage((Object)msg, ctx.getMessage(), this.muleContext);
                    if (ctx != null && ctx.getFlowConstruct() != null && ctx.getFlowConstruct() instanceof Service) {
                        OutboundRouter router = this.createOutboundRouter();
                        router.process(new DefaultMuleEvent(exceptionMessage, RequestContext.getEvent()));
                        break block9;
                    }
                    this.customRouteExceptionMessage(exceptionMessage);
                }
                catch (Exception e) {
                    this.logFatal(message, e);
                    this.closeStream(message);
                }
            } else {
                this.handleTransaction(t);
                this.closeStream(message);
            }
        }
    }

    private void customRouteExceptionMessage(MuleMessage exceptionMessage) throws MessagingException, MuleException, DispatchException {
        int numProcessors = this.messageProcessors.size();
        for (int i = 0; i < numProcessors; ++i) {
            MessageProcessor processor = this.messageProcessors.get(i);
            if (numProcessors > 1 && ((DefaultMuleMessage)exceptionMessage).isConsumable()) {
                throw new MessagingException(CoreMessages.cannotCopyStreamPayload(exceptionMessage.getPayload().getClass().getName()), exceptionMessage);
            }
            DefaultMuleMessage clonedMessage = new DefaultMuleMessage(exceptionMessage.getPayload(), exceptionMessage, this.muleContext);
            MuleEvent exceptionEvent = null;
            exceptionEvent = processor instanceof OutboundEndpoint ? new DefaultMuleEvent(clonedMessage, (OutboundEndpoint)processor, new DefaultMuleSession(this.muleContext)) : new DefaultMuleEvent(clonedMessage, RequestContext.getEvent().getEndpoint(), new DefaultMuleSession(this.muleContext));
            exceptionEvent = RequestContext.setEvent(exceptionEvent);
            processor.process(exceptionEvent);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("routed Exception message via " + processor));
        }
    }

    protected OutboundRouter createOutboundRouter() throws MuleException {
        MulticastingRouter router = new MulticastingRouter(){

            protected void setMessageProperties(FlowConstruct session, MuleMessage message, MessageProcessor target) {
            }
        };
        router.setRoutes(new ArrayList<MessageProcessor>(this.getMessageProcessors()));
        router.setMuleContext(this.muleContext);
        return router;
    }

    protected void closeStream(MuleMessage message) {
        if (this.muleContext == null || this.muleContext.isDisposing() || this.muleContext.isDisposed()) {
            return;
        }
        if (message != null && this.muleContext.getRegistry().lookupObject("_muleStreamCloserService") != null) {
            ((StreamCloserService)this.muleContext.getRegistry().lookupObject("_muleStreamCloserService")).closeStream(message.getPayload());
        }
    }

    protected List<MessageProcessor> getMessageProcessors(Throwable t) {
        if (!this.messageProcessors.isEmpty()) {
            return this.messageProcessors;
        }
        return null;
    }

    protected void logException(Throwable t) {
        MuleException muleException = ExceptionHelper.getRootMuleException(t);
        if (muleException != null) {
            this.logger.error((Object)muleException.getDetailedMessage());
        } else {
            this.logger.error((Object)("Caught exception in Exception Strategy: " + t.getMessage()), t);
        }
    }

    protected void logFatal(MuleMessage message, Throwable t) {
        this.logger.fatal((Object)("Failed to dispatch message to error queue after it failed to process.  This may cause message loss." + (message == null ? "" : "Logging Message here: \n" + message.toString())), t);
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    protected void fireNotification(ExceptionNotification notification) {
        if (this.muleContext != null) {
            this.muleContext.fireNotification(notification);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.debug((Object)("MuleContext is not yet available for firing notifications, ignoring event: " + notification));
        }
    }

    public WildcardFilter getCommitTxFilter() {
        return this.commitTxFilter;
    }

    public void setCommitTxFilter(WildcardFilter commitTxFilter) {
        this.commitTxFilter = commitTxFilter;
    }

    public boolean isEnableNotifications() {
        return this.enableNotifications;
    }

    public void setEnableNotifications(boolean enableNotifications) {
        this.enableNotifications = enableNotifications;
    }

    public WildcardFilter getRollbackTxFilter() {
        return this.rollbackTxFilter;
    }

    public void setRollbackTxFilter(WildcardFilter rollbackTxFilter) {
        this.rollbackTxFilter = rollbackTxFilter;
    }

    @Override
    protected List<MessageProcessor> getOwnedMessageProcessors() {
        return this.messageProcessors;
    }
}

