/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.EndpointURIBuilder;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.ClassUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public class MuleEndpointURI
implements EndpointURI {
    private static final long serialVersionUID = 3906735768171252877L;
    protected static final Log logger = LogFactory.getLog(MuleEndpointURI.class);
    private String address;
    private String filterAddress;
    private String endpointName;
    private String connectorName;
    private String transformers;
    private String responseTransformers;
    private Properties params = new Properties();
    private URI uri;
    private String userInfo;
    private String schemeMetaInfo;
    private String resourceInfo;
    private boolean dynamic;
    private transient MuleContext muleContext;

    public static boolean isMuleUri(String url) {
        return url.indexOf(":/") != -1;
    }

    MuleEndpointURI(String address, String endpointName, String connectorName, String transformers, String responseTransformers, Properties properties, URI uri, String userInfo, MuleContext muleContext) {
        this(address, endpointName, connectorName, transformers, responseTransformers, properties, uri, muleContext);
        if (userInfo != null) {
            this.userInfo = userInfo;
        }
    }

    public MuleEndpointURI(String address, String endpointName, String connectorName, String transformers, String responseTransformers, Properties properties, URI uri, MuleContext muleContext) {
        this.address = address;
        this.endpointName = endpointName;
        this.connectorName = connectorName;
        this.transformers = transformers;
        this.responseTransformers = responseTransformers;
        this.params = properties;
        this.uri = uri;
        this.userInfo = uri.getUserInfo();
        this.muleContext = muleContext;
        if (properties != null) {
            this.resourceInfo = (String)properties.remove("resourceInfo");
        }
    }

    public MuleEndpointURI(EndpointURI endpointUri) {
        this.initialise(endpointUri);
    }

    public MuleEndpointURI(EndpointURI endpointUri, String filterAddress) {
        this.initialise(endpointUri);
        this.filterAddress = filterAddress;
    }

    public MuleEndpointURI(String uri, MuleContext muleContext) throws EndpointException {
        this(uri, null, muleContext);
    }

    public MuleEndpointURI(String uri, String encodedUri, MuleContext muleContext) throws EndpointException {
        this.muleContext = muleContext;
        String startUri = uri = this.preprocessUri(uri);
        uri = this.convertExpressionDelimiters(uri, "#");
        uri = this.convertExpressionDelimiters(uri, "$");
        if (uri.indexOf("#[") >= 0) {
            this.address = uri;
            this.dynamic = true;
        } else {
            try {
                this.uri = new URI(encodedUri != null && uri.equals(startUri) ? this.preprocessUri(encodedUri) : uri);
            }
            catch (URISyntaxException e) {
                throw new MalformedEndpointException(uri, (Throwable)e);
            }
            this.userInfo = this.uri.getRawUserInfo();
        }
    }

    private String convertExpressionDelimiters(String uri, String startChar) {
        int uriLength = uri.length();
        block0: for (int index = 0; index < uriLength && (index = uri.indexOf(startChar + "{", index)) >= 0; index += 2) {
            int braceCount = 1;
            for (int seek = index + 2; seek < uriLength; ++seek) {
                char c = uri.charAt(seek);
                if (c == '{') {
                    ++braceCount;
                    continue;
                }
                if (c != '}' || --braceCount != 0) continue;
                uri = uri.substring(0, index) + startChar + "[" + uri.substring(index + 2, seek) + "]" + uri.substring(seek + 1);
                continue block0;
            }
        }
        return uri;
    }

    protected String preprocessUri(String uri) throws MalformedEndpointException {
        if (!this.validateUrl(uri = uri.trim().replaceAll(" ", "%20"))) {
            throw new MalformedEndpointException(uri);
        }
        this.schemeMetaInfo = this.retrieveSchemeMetaInfo(uri);
        if (this.schemeMetaInfo != null) {
            uri = uri.replaceFirst(this.schemeMetaInfo + ":", "");
        }
        return uri;
    }

    public void initialise() throws InitialisationException {
        try {
            String scheme = this.getFullScheme();
            TransportServiceDescriptor sd = (TransportServiceDescriptor)this.muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, scheme, null);
            if (sd == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
            }
            EndpointURIBuilder builder = sd.createEndpointURIBuilder();
            EndpointURI built = builder.build(this.uri, this.muleContext);
            this.initialise(built);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private String retrieveSchemeMetaInfo(String url) {
        int i = url.indexOf(58);
        if (i == -1) {
            return null;
        }
        if (url.charAt(i + 1) == '/') {
            return null;
        }
        return url.substring(0, i);
    }

    protected boolean validateUrl(String url) {
        return url.indexOf(":/") > 0;
    }

    private void initialise(EndpointURI endpointUri) {
        this.address = endpointUri.getAddress();
        if (this.endpointName == null) {
            this.endpointName = endpointUri.getEndpointName();
        }
        this.connectorName = endpointUri.getConnectorName();
        this.transformers = endpointUri.getTransformers();
        this.responseTransformers = endpointUri.getResponseTransformers();
        this.params = endpointUri.getParams();
        this.uri = endpointUri.getUri();
        this.resourceInfo = endpointUri.getResourceInfo();
        this.userInfo = endpointUri.getUserInfo();
    }

    public String getAddress() {
        return this.address;
    }

    public String getEndpointName() {
        return StringUtils.isEmpty((String)this.endpointName) ? null : this.endpointName;
    }

    public Properties getParams() {
        if (this.params.size() == 0 && this.getQuery() != null) {
            this.params = PropertiesUtils.getPropertiesFromQueryString(this.getQuery());
        }
        return this.params;
    }

    public Properties getUserParams() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.getParams());
        p.remove("endpointName");
        p.remove("address");
        p.remove("transformers");
        return p;
    }

    public URI parseServerAuthority() throws URISyntaxException {
        return this.uri.parseServerAuthority();
    }

    public URI normalize() {
        return this.uri.normalize();
    }

    public URI resolve(URI uri) {
        return uri.resolve(uri);
    }

    public URI resolve(String str) {
        return this.uri.resolve(str);
    }

    public URI relativize(URI uri) {
        return uri.relativize(uri);
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getFullScheme() {
        String scheme;
        if (this.dynamic) {
            int colon = this.address.indexOf(58);
            scheme = this.address.substring(0, colon);
        } else {
            scheme = this.uri.getScheme();
        }
        return this.schemeMetaInfo == null ? scheme : this.schemeMetaInfo + ':' + scheme;
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    public boolean isOpaque() {
        return this.uri.isOpaque();
    }

    public String getRawSchemeSpecificPart() {
        return this.uri.getRawSchemeSpecificPart();
    }

    public String getSchemeSpecificPart() {
        return this.uri.getSchemeSpecificPart();
    }

    public String getRawAuthority() {
        return this.uri.getRawAuthority();
    }

    public String getAuthority() {
        return this.uri.getAuthority();
    }

    public String getRawUserInfo() {
        return this.uri.getRawUserInfo();
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getRawPath() {
        return this.uri.getRawPath();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getRawQuery() {
        return this.uri.getRawQuery();
    }

    public String getQuery() {
        return this.uri.getQuery();
    }

    public String getRawFragment() {
        return this.uri.getRawFragment();
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public String toString() {
        if (StringUtils.isNotEmpty((String)this.userInfo) && this.userInfo.indexOf(":") > 0) {
            String maskinfo = this.userInfo.substring(0, this.userInfo.indexOf(":")) + ":****";
            return this.uri.toASCIIString().replace(this.userInfo, maskinfo);
        }
        return this.uri.toASCIIString();
    }

    public String getTransformers() {
        return this.transformers;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public String getSchemeMetaInfo() {
        return this.schemeMetaInfo == null ? this.uri.getScheme() : this.schemeMetaInfo;
    }

    public String getResourceInfo() {
        return this.resourceInfo;
    }

    public String getFilterAddress() {
        return this.filterAddress;
    }

    public String getUser() {
        if (StringUtils.isNotBlank((String)this.userInfo)) {
            int i = this.userInfo.indexOf(58);
            if (i == -1) {
                return this.userInfo;
            }
            return this.userInfo.substring(0, i);
        }
        return null;
    }

    public String getResponseTransformers() {
        return this.responseTransformers;
    }

    public String getPassword() {
        int i;
        if (StringUtils.isNotBlank((String)this.userInfo) && (i = this.userInfo.indexOf(58)) > -1) {
            return this.userInfo.substring(i + 1);
        }
        return null;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleEndpointURI)) {
            return false;
        }
        MuleEndpointURI muleEndpointURI = (MuleEndpointURI)o;
        return ClassUtils.equal(this.address, muleEndpointURI.address) && ClassUtils.equal(this.connectorName, muleEndpointURI.connectorName) && ClassUtils.equal(this.endpointName, muleEndpointURI.endpointName) && ClassUtils.equal(this.filterAddress, muleEndpointURI.filterAddress) && ClassUtils.equal(this.params, muleEndpointURI.params) && ClassUtils.equal(this.resourceInfo, muleEndpointURI.resourceInfo) && ClassUtils.equal(this.schemeMetaInfo, muleEndpointURI.schemeMetaInfo) && ClassUtils.equal(this.transformers, muleEndpointURI.transformers) && ClassUtils.equal(this.responseTransformers, muleEndpointURI.responseTransformers) && ClassUtils.equal(this.uri, muleEndpointURI.uri);
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.address, this.filterAddress, this.endpointName, this.connectorName, this.transformers, this.responseTransformers, this.params, this.uri, this.schemeMetaInfo, this.resourceInfo});
    }
}

