/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.routing.OutboundRouter;
import org.mule.exception.AbstractMessagingExceptionStrategy;
import org.mule.message.DefaultExceptionPayload;
import org.mule.session.DefaultMuleSession;
import org.mule.transport.NullPayload;
import org.mule.util.ObjectUtils;

public class RouteableExceptionStrategy
extends AbstractMessagingExceptionStrategy
implements FlowConstructAware,
Lifecycle {
    private OutboundRouter router;
    private boolean stopFurtherProcessing = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent handleException(Exception e, MuleEvent event) {
        int currentRootExceptionHashCode = 0;
        int originalRootExceptionHashCode = 0;
        MuleMessage msg = null;
        StringBuffer logInfo = new StringBuffer();
        try {
            Object serviceName;
            logInfo.append("****++******Alternate Exception Strategy******++*******\n");
            logInfo.append("Current Thread = " + Thread.currentThread().toString() + "\n");
            if (event != null && event.getFlowConstruct() != null) {
                serviceName = event.getFlowConstruct().getName();
                logInfo.append("serviceName = " + (String)serviceName + "\n");
                int eventHashCode = event.hashCode();
                logInfo.append("eventHashCode = " + eventHashCode + "\n");
            }
            if (event != null && event.isStopFurtherProcessing()) {
                logInfo.append("MuleEvent stop further processing has been set, This is probably the same exception being routed again. no Exception routing will be performed.\n" + e + "\n");
                event.getMessage().setPayload(NullPayload.getInstance());
                event.getMessage().setExceptionPayload(new DefaultExceptionPayload(e));
                serviceName = event;
                return serviceName;
            }
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            currentRootExceptionHashCode = root == null ? -1 : root.hashCode();
            MuleMessage muleMessage = msg = event == null ? null : event.getMessage();
            if (msg != null) {
                Object t;
                int msgHashCode = msg.hashCode();
                logInfo.append("msgHashCode = " + msgHashCode + "\n");
                if (msg.getExceptionPayload() != null && (t = msg.getExceptionPayload().getRootException()) != null && t.hashCode() == currentRootExceptionHashCode) {
                    logInfo.append("*#*#*#*#*\n");
                    logInfo.append("This error has already been handeled, returning without doing anything: " + e.getMessage() + "\n");
                    logInfo.append("*#*#*#*#*\n");
                    originalRootExceptionHashCode = currentRootExceptionHashCode;
                    event.getMessage().setPayload(NullPayload.getInstance());
                    event.getMessage().setExceptionPayload(new DefaultExceptionPayload(e));
                    MuleEvent muleEvent = event;
                    return muleEvent;
                }
                originalRootExceptionHashCode = msg.getIntProperty("RootExceptionHashCode", 0);
                logInfo.append("Original RootExceptionHashCode: " + originalRootExceptionHashCode + "\n");
                logInfo.append("Current  RootExceptionHashCode: " + currentRootExceptionHashCode + "\n");
                if (originalRootExceptionHashCode == 0) {
                    msg.setIntProperty("RootExceptionHashCode", currentRootExceptionHashCode);
                    originalRootExceptionHashCode = currentRootExceptionHashCode;
                } else {
                    if (originalRootExceptionHashCode == currentRootExceptionHashCode) {
                        logInfo.append("*#*#*#*#*\n");
                        logInfo.append("This error has already been handeled, returning without doing anything: " + e.getMessage() + "\n");
                        logInfo.append("*#*#*#*#*\n");
                        event.getMessage().setPayload(NullPayload.getInstance());
                        event.getMessage().setExceptionPayload(new DefaultExceptionPayload(e));
                        t = event;
                        return t;
                    }
                    msg.setIntProperty("RootExceptionHashCode", currentRootExceptionHashCode);
                }
            }
            logInfo.append(e.getMessage());
            StackTraceElement[] st = e.getStackTrace();
            for (int i = 0; i < st.length; ++i) {
                if (st[i].getClassName().equals("org.mule.AlternateExceptionStrategy")) {
                    this.logger.warn((Object)("*#*#*#*#*\nRecursive error in AlternateExceptionStrategy " + e + "\n" + "*#*#*#*#*"));
                    event.getMessage().setPayload(NullPayload.getInstance());
                    event.getMessage().setExceptionPayload(new DefaultExceptionPayload(e));
                    MuleEvent muleEvent = event;
                    return muleEvent;
                }
                this.logger.debug((Object)st[i].toString());
            }
            MuleEvent muleEvent = super.handleException(e, event);
            return muleEvent;
        }
        finally {
            if (event != null && this.stopFurtherProcessing) {
                event.setStopFurtherProcessing(true);
            }
            if (msg != null && currentRootExceptionHashCode != 0 && currentRootExceptionHashCode != originalRootExceptionHashCode) {
                msg.setIntProperty("RootExceptionHashCode", currentRootExceptionHashCode);
            }
            logInfo.append("****__******Alternate Exception Strategy******__*******\n");
            this.logger.debug((Object)logInfo.toString());
        }
    }

    public void handleMessagingException(MuleMessage message, Throwable t) {
        this.defaultHandler(message, t);
        this.routeException(this.getMessageFromContext(message), (ImmutableEndpoint)null, t);
    }

    public void handleRoutingException(MuleMessage message, ImmutableEndpoint endpoint, Throwable t) {
        this.defaultHandler(message, t);
        this.routeException(this.getMessageFromContext(message), endpoint, t);
    }

    public void handleLifecycleException(Object component, Throwable t) {
        this.logger.error((Object)("The object that failed is: \n" + ObjectUtils.toString((Object)component, (String)"null")));
        this.handleStandardException(t);
    }

    public void handleStandardException(Throwable t) {
        this.handleTransaction(t);
        if (RequestContext.getEvent() != null) {
            this.handleMessagingException(RequestContext.getEvent().getMessage(), t);
        } else {
            this.logger.info((Object)"There is no current event available, routing Null message with the exception");
            this.handleMessagingException(new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext), t);
        }
    }

    protected void defaultHandler(MuleMessage message, Throwable t) {
        if (RequestContext.getEvent() != null && RequestContext.getEvent().getMessage() != null) {
            RequestContext.getEvent().getMessage().setExceptionPayload(new DefaultExceptionPayload(t));
        }
        if (message != null) {
            message.setExceptionPayload(new DefaultExceptionPayload(t));
        }
    }

    protected MuleMessage getMessageFromContext(MuleMessage message) {
        if (RequestContext.getEvent() != null) {
            return RequestContext.getEvent().getMessage();
        }
        if (message != null) {
            return message;
        }
        return new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext);
    }

    protected void routeException(MuleMessage msg, ImmutableEndpoint failedEndpoint, Throwable t) {
        MuleMessage contextMsg = null;
        MuleEvent exceptionEvent = RequestContext.getEvent();
        MuleMessage muleMessage = contextMsg = exceptionEvent == null ? msg : exceptionEvent.getMessage();
        if (contextMsg == null) {
            contextMsg = new DefaultMuleMessage(NullPayload.getInstance(), this.muleContext);
            contextMsg.setExceptionPayload(new DefaultExceptionPayload(t));
        }
        if (exceptionEvent == null) {
            exceptionEvent = new DefaultMuleEvent(contextMsg, failedEndpoint, new DefaultMuleSession(this.muleContext));
        }
        DefaultMuleMessage messageCopy = new DefaultMuleMessage(contextMsg.getPayload(), contextMsg, this.muleContext);
        try {
            this.router.process(exceptionEvent);
        }
        catch (MuleException e) {
            this.logFatal(messageCopy, e);
        }
    }

    public OutboundRouter getRouter() {
        return this.router;
    }

    public void setRouter(OutboundRouter router) {
        this.router = router;
    }

    public boolean isStopFurtherProcessing() {
        return this.stopFurtherProcessing;
    }

    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.stopFurtherProcessing = stopFurtherProcessing;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        if (this.router instanceof FlowConstructAware) {
            this.router.setFlowConstruct(flowConstruct);
        }
    }

    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
        if (this.router instanceof MuleContextAware) {
            this.router.setMuleContext(context);
        }
    }

    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        if (this.router instanceof Initialisable) {
            this.router.initialise();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.router instanceof Disposable) {
            this.router.dispose();
        }
    }

    public void stop() throws MuleException {
        if (this.router instanceof Stoppable) {
            this.router.stop();
        }
    }

    public void start() throws MuleException {
        if (this.router instanceof Stoppable) {
            this.router.stop();
        }
    }
}

