/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.generics;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Map;
import org.mule.util.generics.GenericTypeResolver;
import org.mule.util.generics.MethodParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsUtils {
    public static Class<?> getCollectionType(Class<? extends Collection<?>> collectionClass) {
        return GenericsUtils.extractTypeFromClass(collectionClass, Collection.class, 0);
    }

    public static Class<?> getMapKeyType(Class<? extends Map<?, ?>> mapClass) {
        return GenericsUtils.extractTypeFromClass(mapClass, Map.class, 0);
    }

    public static Class<?> getMapValueType(Class<? extends Map<?, ?>> mapClass) {
        return GenericsUtils.extractTypeFromClass(mapClass, Map.class, 1);
    }

    public static Class<?> getCollectionFieldType(Field collectionField) {
        return GenericsUtils.getGenericFieldType(collectionField, Collection.class, 0, 1);
    }

    public static Class<?> getCollectionFieldType(Field collectionField, int nestingLevel) {
        return GenericsUtils.getGenericFieldType(collectionField, Collection.class, 0, nestingLevel);
    }

    public static Class<?> getMapKeyFieldType(Field mapField) {
        return GenericsUtils.getGenericFieldType(mapField, Map.class, 0, 1);
    }

    public static Class<?> getMapKeyFieldType(Field mapField, int nestingLevel) {
        return GenericsUtils.getGenericFieldType(mapField, Map.class, 0, nestingLevel);
    }

    public static Class<?> getMapValueFieldType(Field mapField) {
        return GenericsUtils.getGenericFieldType(mapField, Map.class, 1, 1);
    }

    public static Class<?> getMapValueFieldType(Field mapField, int nestingLevel) {
        return GenericsUtils.getGenericFieldType(mapField, Map.class, 1, nestingLevel);
    }

    public static Class<?> getCollectionParameterType(MethodParameter methodParam) {
        return GenericsUtils.getGenericParameterType(methodParam, Collection.class, 0);
    }

    public static Class<?> getMapKeyParameterType(MethodParameter methodParam) {
        return GenericsUtils.getGenericParameterType(methodParam, Map.class, 0);
    }

    public static Class<?> getMapValueParameterType(MethodParameter methodParam) {
        return GenericsUtils.getGenericParameterType(methodParam, Map.class, 1);
    }

    public static Class<?> getCollectionReturnType(Method method) {
        return GenericsUtils.getGenericReturnType(method, Collection.class, 0, 1);
    }

    public static Class<?> getCollectionReturnType(Method method, int nestingLevel) {
        return GenericsUtils.getGenericReturnType(method, Collection.class, 0, nestingLevel);
    }

    public static Class<?> getMapKeyReturnType(Method method) {
        return GenericsUtils.getGenericReturnType(method, Map.class, 0, 1);
    }

    public static Class<?> getMapKeyReturnType(Method method, int nestingLevel) {
        return GenericsUtils.getGenericReturnType(method, Map.class, 0, nestingLevel);
    }

    public static Class<?> getMapValueReturnType(Method method) {
        return GenericsUtils.getGenericReturnType(method, Map.class, 1, 1);
    }

    public static Class<?> getMapValueReturnType(Method method, int nestingLevel) {
        return GenericsUtils.getGenericReturnType(method, Map.class, 1, nestingLevel);
    }

    private static Class<?> getGenericParameterType(MethodParameter methodParam, Class<?> source, int typeIndex) {
        return GenericsUtils.extractType(methodParam, GenericTypeResolver.getTargetType(methodParam), source, typeIndex, methodParam.getNestingLevel(), 1);
    }

    private static Class<?> getGenericFieldType(Field field, Class<?> source, int typeIndex, int nestingLevel) {
        return GenericsUtils.extractType(null, field.getGenericType(), source, typeIndex, nestingLevel, 1);
    }

    private static Class<?> getGenericReturnType(Method method, Class<?> source, int typeIndex, int nestingLevel) {
        return GenericsUtils.extractType(null, method.getGenericReturnType(), source, typeIndex, nestingLevel, 1);
    }

    private static Class<?> extractType(MethodParameter methodParam, Type type, Class<?> source, int typeIndex, int nestingLevel, int currentLevel) {
        Type mappedType;
        Type resolvedType = type;
        if (type instanceof TypeVariable && methodParam != null && methodParam.typeVariableMap != null && (mappedType = methodParam.typeVariableMap.get(type)) != null) {
            resolvedType = mappedType;
        }
        if (resolvedType instanceof ParameterizedType) {
            return GenericsUtils.extractTypeFromParameterizedType(methodParam, (ParameterizedType)resolvedType, source, typeIndex, nestingLevel, currentLevel);
        }
        if (resolvedType instanceof Class) {
            Class resolvedClass = (Class)resolvedType;
            return GenericsUtils.extractTypeFromClass(methodParam, resolvedClass, source, typeIndex, nestingLevel, currentLevel);
        }
        return null;
    }

    private static Class<?> extractTypeFromParameterizedType(MethodParameter methodParam, ParameterizedType ptype, Class<?> source, int typeIndex, int nestingLevel, int currentLevel) {
        Type mappedType;
        if (!(ptype.getRawType() instanceof Class)) {
            return null;
        }
        Class rawType = (Class)ptype.getRawType();
        Type[] paramTypes = ptype.getActualTypeArguments();
        if (nestingLevel - currentLevel > 0) {
            int nextLevel = currentLevel + 1;
            Integer currentTypeIndex = methodParam != null ? methodParam.getTypeIndexForLevel(nextLevel) : null;
            int indexToUse = currentTypeIndex != null ? currentTypeIndex : paramTypes.length - 1;
            Type paramType = paramTypes[indexToUse];
            return GenericsUtils.extractType(methodParam, paramType, source, typeIndex, nestingLevel, nextLevel);
        }
        if (source != null && !source.isAssignableFrom(rawType)) {
            return null;
        }
        Class<?> fromSuperclassOrInterface = GenericsUtils.extractTypeFromClass(methodParam, rawType, source, typeIndex, nestingLevel, currentLevel);
        if (fromSuperclassOrInterface != null) {
            return fromSuperclassOrInterface;
        }
        if (paramTypes == null || typeIndex >= paramTypes.length) {
            return null;
        }
        Type paramType = paramTypes[typeIndex];
        if (paramType instanceof TypeVariable && methodParam != null && methodParam.typeVariableMap != null && (mappedType = methodParam.typeVariableMap.get(paramType)) != null) {
            paramType = mappedType;
        }
        if (paramType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)paramType;
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds != null && upperBounds.length > 0 && !Object.class.equals((Object)upperBounds[0])) {
                paramType = upperBounds[0];
            } else {
                Type[] lowerBounds = wildcardType.getLowerBounds();
                if (lowerBounds != null && lowerBounds.length > 0 && !Object.class.equals((Object)lowerBounds[0])) {
                    paramType = lowerBounds[0];
                }
            }
        }
        if (paramType instanceof ParameterizedType) {
            paramType = ((ParameterizedType)paramType).getRawType();
        }
        if (paramType instanceof GenericArrayType) {
            Type compType = ((GenericArrayType)paramType).getGenericComponentType();
            if (compType instanceof Class) {
                Class compClass = (Class)compType;
                return Array.newInstance(compClass, 0).getClass();
            }
        } else if (paramType instanceof Class) {
            return (Class)paramType;
        }
        return null;
    }

    private static Class<?> extractTypeFromClass(Class<?> clazz, Class<?> source, int typeIndex) {
        return GenericsUtils.extractTypeFromClass(null, clazz, source, typeIndex, 1, 1);
    }

    private static Class<?> extractTypeFromClass(MethodParameter methodParam, Class<?> clazz, Class<?> source, int typeIndex, int nestingLevel, int currentLevel) {
        if (clazz.getName().startsWith("java.util.")) {
            return null;
        }
        if (clazz.getSuperclass() != null && GenericsUtils.isIntrospectionCandidate(clazz.getSuperclass())) {
            return GenericsUtils.extractType(methodParam, clazz.getGenericSuperclass(), source, typeIndex, nestingLevel, currentLevel);
        }
        Type[] ifcs = clazz.getGenericInterfaces();
        if (ifcs != null) {
            Type[] arr$ = ifcs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Type ifc;
                Type rawType = ifc = arr$[i$];
                if (ifc instanceof ParameterizedType) {
                    rawType = ((ParameterizedType)ifc).getRawType();
                }
                if (!(rawType instanceof Class) || !GenericsUtils.isIntrospectionCandidate((Class)rawType)) continue;
                return GenericsUtils.extractType(methodParam, ifc, source, typeIndex, nestingLevel, currentLevel);
            }
        }
        return null;
    }

    private static boolean isIntrospectionCandidate(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }
}

