/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.Component;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.model.Model;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.MessageProcessorChainBuilder;
import org.mule.api.routing.MessageInfoMapping;
import org.mule.api.routing.RouterStatisticsRecorder;
import org.mule.api.service.Service;
import org.mule.api.source.MessageSource;
import org.mule.component.simple.PassThroughComponent;
import org.mule.config.i18n.CoreMessages;
import org.mule.lifecycle.EmptyLifecycleCallback;
import org.mule.lifecycle.processor.ProcessIfStartedWaitIfPausedMessageProcessor;
import org.mule.management.stats.RouterStatistics;
import org.mule.management.stats.ServiceStatistics;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.routing.MuleMessageInfoMapping;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.service.ServiceAsyncReplyCompositeMessageSource;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.service.ServiceLifecycleManager;
import org.mule.service.processor.ServiceAsyncRequestReplyRequestor;
import org.mule.session.DefaultMuleSession;
import org.mule.util.ClassUtils;

public abstract class AbstractService
implements Service,
MessageProcessor {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected ServiceStatistics stats;
    protected Model model;
    protected MuleContext muleContext;
    protected ServiceLifecycleManager lifecycleManager;
    public static final String INITIAL_STATE_STOPPED = "stopped";
    public static final String INITIAL_STATE_STARTED = "started";
    public static final String INITIAL_STATE_PAUSED = "paused";
    protected MessagingExceptionHandler exceptionListener;
    protected String name;
    protected MessageProcessor outboundRouter = new DefaultOutboundRouterCollection();
    protected MessageSource messageSource = new ServiceCompositeMessageSource();
    protected ServiceAsyncReplyCompositeMessageSource asyncReplyMessageSource = new ServiceAsyncReplyCompositeMessageSource();
    protected MessageProcessorChain messageProcessorChain;
    protected MessageInfoMapping messageInfoMapping = new MuleMessageInfoMapping();
    protected String initialState = "started";
    protected Component component = new PassThroughComponent();

    public AbstractService(MuleContext muleContext) {
        this.muleContext = muleContext;
        ((MuleContextAware)((Object)this.component)).setMuleContext(muleContext);
        try {
            this.lifecycleManager = new ServiceLifecycleManager(this, muleContext);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreate("Service Lifecycle Manager"), (Throwable)e);
        }
    }

    public final synchronized void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase(new LifecycleCallback<FlowConstruct>(){

                @Override
                public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                    if (AbstractService.this.outboundRouter instanceof MuleContextAware) {
                        ((MuleContextAware)((Object)AbstractService.this.outboundRouter)).setMuleContext(AbstractService.this.muleContext);
                    }
                    if (AbstractService.this.exceptionListener == null) {
                        AbstractService.this.exceptionListener = AbstractService.this.getModel().getExceptionListener();
                    }
                    if (AbstractService.this.messageSource instanceof FlowConstructAware) {
                        ((FlowConstructAware)((Object)AbstractService.this.messageSource)).setFlowConstruct(object);
                    }
                    AbstractService.this.asyncReplyMessageSource.setFlowConstruct(object);
                    AbstractService.this.component.setFlowConstruct(object);
                    AbstractService.this.doInitialise();
                }
            });
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public void start() throws MuleException {
        if (!this.isStopped() && this.initialState.equals(INITIAL_STATE_STOPPED)) {
            this.lifecycleManager.fireStartPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            this.lifecycleManager.fireStopPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            this.logger.info((Object)("Service " + this.name + " has not been started (initial state = 'stopped')"));
            return;
        }
        this.lifecycleManager.fireStartPhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doStart();
            }
        });
        if (this.initialState.equals(INITIAL_STATE_PAUSED)) {
            this.pause();
            this.logger.info((Object)("Service " + this.name + " has been started and paused (initial state = 'paused')"));
        }
    }

    public final void pause() throws MuleException {
        this.lifecycleManager.firePausePhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doPause();
            }
        });
    }

    public final void resume() throws MuleException {
        this.lifecycleManager.fireResumePhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doResume();
            }
        });
    }

    public void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase(new LifecycleCallback<FlowConstruct>(){

            @Override
            public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                AbstractService.this.doStop();
            }
        });
    }

    public final void dispose() {
        try {
            if (this.isStarted()) {
                this.stop();
            }
            this.lifecycleManager.fireDisposePhase(new LifecycleCallback<FlowConstruct>(){

                @Override
                public void onTransition(String phaseName, FlowConstruct object) throws MuleException {
                    AbstractService.this.doDispose();
                }
            });
        }
        catch (MuleException e) {
            this.logger.error((Object)("Failed to stop service: " + this.name), (Throwable)e);
        }
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    public boolean isStarted() {
        return this.lifecycleManager.getState().isStarted();
    }

    public boolean isPaused() {
        return this.lifecycleManager.getCurrentPhase().equals("pause");
    }

    public boolean isStopped() {
        return this.lifecycleManager.getState().isStopped();
    }

    public boolean isStopping() {
        return this.lifecycleManager.getState().isStopping();
    }

    protected void doPause() throws MuleException {
    }

    protected void doResume() throws MuleException {
    }

    protected void doForceStop() throws MuleException {
    }

    protected void doStop() throws MuleException {
        if (this.messageSource instanceof Stoppable) {
            ((Stoppable)((Object)this.messageSource)).stop();
        }
        this.asyncReplyMessageSource.stop();
        if (this.component instanceof Stoppable) {
            ((Stoppable)((Object)this.component)).stop();
        }
        if (this.messageProcessorChain instanceof Stoppable) {
            ((Stoppable)((Object)this.messageProcessorChain)).stop();
        }
    }

    protected void doStart() throws MuleException {
        if (this.component instanceof Startable) {
            ((Startable)((Object)this.component)).start();
        }
        if (this.messageProcessorChain instanceof Startable) {
            ((Startable)((Object)this.messageProcessorChain)).start();
        }
        if (this.messageSource instanceof Startable) {
            ((Startable)((Object)this.messageSource)).start();
        }
        if (this.asyncReplyMessageSource.getEndpoints().size() > 0) {
            this.asyncReplyMessageSource.start();
        }
    }

    protected void doDispose() {
        if (this.component instanceof Disposable) {
            ((Disposable)((Object)this.component)).dispose();
        }
        if (this.messageProcessorChain instanceof Disposable) {
            ((Disposable)((Object)this.messageProcessorChain)).dispose();
        }
        if (this.messageSource instanceof Disposable) {
            ((Disposable)((Object)this.messageSource)).dispose();
        }
        this.muleContext.getStatistics().remove(this.stats);
    }

    protected void doInitialise() throws InitialisationException {
        this.stats = this.createStatistics();
        this.stats.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.stats);
        RouterStatistics routerStatistics = new RouterStatistics(2);
        this.stats.setOutboundRouterStat(routerStatistics);
        if (this.outboundRouter != null && this.outboundRouter instanceof RouterStatisticsRecorder) {
            ((RouterStatisticsRecorder)((Object)this.outboundRouter)).setRouterStatistics(routerStatistics);
        }
        RouterStatistics inboundRouterStatistics = new RouterStatistics(1);
        this.stats.setInboundRouterStat(inboundRouterStatistics);
        if (this.messageSource instanceof RouterStatisticsRecorder) {
            ((RouterStatisticsRecorder)((Object)this.messageSource)).setRouterStatistics(inboundRouterStatistics);
        }
        this.stats.setComponentStat(this.component.getStatistics());
        try {
            this.buildServiceMessageProcessorChain();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        this.messageSource.setListener(new AbstractInterceptingMessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return AbstractService.this.messageProcessorChain.process(event);
            }
        });
        if (this.component instanceof Initialisable) {
            ((Initialisable)((Object)this.component)).initialise();
        }
        if (this.messageProcessorChain instanceof Initialisable) {
            ((Initialisable)((Object)this.messageProcessorChain)).initialise();
        }
        if (this.messageSource instanceof Initialisable) {
            ((Initialisable)((Object)this.messageSource)).initialise();
        }
        if (this.asyncReplyMessageSource.getEndpoints().size() > 0) {
            this.asyncReplyMessageSource.initialise();
        }
    }

    public void forceStop() throws MuleException {
        this.doForceStop();
        this.stop();
    }

    protected void buildServiceMessageProcessorChain() throws MuleException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder(this);
        builder.setName("Service '" + this.name + "' Processor Chain");
        builder.chain(this.getServiceStartedAssertingMessageProcessor());
        this.addMessageProcessors(builder);
        this.messageProcessorChain = builder.build();
    }

    protected MessageProcessor getServiceStartedAssertingMessageProcessor() {
        return new ProcessIfStartedWaitIfPausedMessageProcessor(this, this.lifecycleManager.getState());
    }

    protected abstract void addMessageProcessors(MessageProcessorChainBuilder var1);

    protected ServiceStatistics createStatistics() {
        return new ServiceStatistics(this.name);
    }

    public ServiceStatistics getStatistics() {
        return this.stats;
    }

    @Deprecated
    public void dispatchEvent(MuleEvent event) throws MuleException {
        this.messageProcessorChain.process(event);
    }

    @Deprecated
    public MuleEvent sendEvent(MuleEvent event) throws MuleException {
        return this.messageProcessorChain.process(event);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s{%s}", ClassUtils.getSimpleName(this.getClass()), this.getName());
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public MessagingExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource inboundMessageSource) {
        this.messageSource = inboundMessageSource;
    }

    public MessageProcessor getOutboundMessageProcessor() {
        return this.outboundRouter;
    }

    @Deprecated
    public void setMessageProcessor(MessageProcessor processor) {
        this.setOutboundMessageProcessor(processor);
    }

    public void setOutboundMessageProcessor(MessageProcessor processor) {
        this.outboundRouter = processor;
    }

    public ServiceAsyncReplyCompositeMessageSource getAsyncReplyMessageSource() {
        return this.asyncReplyMessageSource;
    }

    public void setAsyncReplyMessageSource(ServiceAsyncReplyCompositeMessageSource asyncReplyMessageSource) {
        this.asyncReplyMessageSource = asyncReplyMessageSource;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.component.setFlowConstruct(this);
        if (component instanceof MuleContextAware) {
            ((MuleContextAware)((Object)component)).setMuleContext(this.muleContext);
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public MessageInfoMapping getMessageInfoMapping() {
        return this.messageInfoMapping;
    }

    public void setMessageInfoMapping(MessageInfoMapping messageInfoMapping) {
        this.messageInfoMapping = messageInfoMapping;
    }

    protected long getAsyncReplyTimeout() {
        if (this.asyncReplyMessageSource.getTimeout() != null) {
            return this.asyncReplyMessageSource.getTimeout();
        }
        return this.muleContext.getConfiguration().getDefaultResponseTimeout();
    }

    protected ServiceAsyncRequestReplyRequestor createAsyncReplyProcessor() {
        ServiceAsyncRequestReplyRequestor asyncReplyMessageProcessor = new ServiceAsyncRequestReplyRequestor();
        asyncReplyMessageProcessor.setTimeout(this.getAsyncReplyTimeout());
        asyncReplyMessageProcessor.setFailOnTimeout(this.asyncReplyMessageSource.isFailOnTimeout());
        asyncReplyMessageProcessor.setReplySource(this.asyncReplyMessageSource);
        return asyncReplyMessageProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MuleEvent process(MuleEvent event) throws MuleException {
        DefaultMuleSession calledSession = new DefaultMuleSession(event.getSession(), this);
        DefaultMuleEvent newEvent = new DefaultMuleEvent(event.getMessage(), event.getEndpoint(), event, calledSession);
        RequestContext.setEvent(newEvent);
        try {
            MuleEvent muleEvent = this.messageProcessorChain.process(newEvent);
            return muleEvent;
        }
        finally {
            RequestContext.setEvent(event);
        }
    }

    public MessageProcessorChain getMessageProcessorChain() {
        return this.messageProcessorChain;
    }
}

