/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.RouterResultsHandler;
import org.mule.api.routing.RoutingException;
import org.mule.api.transaction.TransactionCallback;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.CorrelationMode;
import org.mule.routing.DefaultRouterResultsHandler;
import org.mule.transaction.TransactionTemplate;
import org.mule.util.StringMessageUtils;
import org.mule.util.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutboundRouter
implements OutboundRouter {
    protected static List<String> magicProperties = Arrays.asList("MULE_CORRELATION_ID", "MULE_CORRELATION_ID", "MULE_CORRELATION_GROUP_SIZE", "MULE_CORRELATION_SEQUENCE", "MULE_SESSION");
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected List<MessageProcessor> routes = new CopyOnWriteArrayList();
    protected String replyTo = null;
    protected CorrelationMode enableCorrelation = CorrelationMode.IF_NOT_SET;
    protected TransactionConfig transactionConfig;
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    private RouterStatistics routerStatistics;
    protected MuleContext muleContext;
    protected FlowConstruct flowConstruct;
    protected AtomicBoolean initialised = new AtomicBoolean(false);
    protected AtomicBoolean started = new AtomicBoolean(false);

    @Override
    public MuleEvent process(final MuleEvent event) throws MuleException {
        TransactionTemplate<MuleEvent> tt = new TransactionTemplate<MuleEvent>(this.getTransactionConfig(), this.muleContext);
        TransactionCallback<MuleEvent> cb = new TransactionCallback<MuleEvent>(){

            @Override
            public MuleEvent doInTransaction() throws Exception {
                return AbstractOutboundRouter.this.route(event);
            }
        };
        try {
            return tt.execute(cb);
        }
        catch (RoutingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RoutingException(event, this, (Throwable)e);
        }
    }

    protected abstract MuleEvent route(MuleEvent var1) throws MessagingException;

    protected final MuleEvent sendRequest(MuleEvent routedEvent, MuleMessage message, MessageProcessor route, boolean awaitResponse) throws MuleException {
        MuleEvent result;
        block15: {
            if (awaitResponse && this.replyTo != null) {
                this.logger.debug((Object)"event was dispatched synchronously, but there is a ReplyTo route set, so using asynchronous dispatch");
                awaitResponse = false;
            }
            this.setMessageProperties(routedEvent.getSession().getFlowConstruct(), message, route);
            if (this.logger.isDebugEnabled()) {
                if (route instanceof OutboundEndpoint) {
                    this.logger.debug((Object)("Message being sent to: " + ((OutboundEndpoint)route).getEndpointURI()));
                }
                this.logger.debug((Object)message);
            }
            if (this.logger.isTraceEnabled()) {
                try {
                    this.logger.trace((Object)("Request payload: \n" + StringMessageUtils.truncate(message.getPayloadForLogging(), 100, false)));
                    if (route instanceof OutboundEndpoint) {
                        this.logger.trace((Object)("outbound transformer is: " + ((OutboundEndpoint)route).getTransformers()));
                    }
                }
                catch (Exception e) {
                    this.logger.trace((Object)("Request payload: \n(unable to retrieve payload: " + e.getMessage()));
                    if (!(route instanceof OutboundEndpoint)) break block15;
                    this.logger.trace((Object)("outbound transformer is: " + ((OutboundEndpoint)route).getTransformers()));
                }
            }
        }
        try {
            result = this.sendRequestEvent(routedEvent, message, route, awaitResponse);
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (Exception e) {
            throw new RoutingException(routedEvent, null, (Throwable)e);
        }
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementRoutedMessage(route);
        }
        if (result != null) {
            MuleMessage resultMessage = result.getMessage();
            if (this.logger.isTraceEnabled() && resultMessage != null) {
                try {
                    this.logger.trace((Object)("Response payload: \n" + StringMessageUtils.truncate(resultMessage.getPayloadForLogging(), 100, false)));
                }
                catch (Exception e) {
                    this.logger.trace((Object)("Response payload: \n(unable to retrieve payload: " + e.getMessage()));
                }
            }
        }
        return result;
    }

    protected void setMessageProperties(FlowConstruct service, MuleMessage message, MessageProcessor route) {
        if (this.replyTo != null) {
            message.setReplyTo(this.replyTo);
            message.setOutboundProperty("MULE_REPLYTO_REQUESTOR", service.getName());
            if (this.logger.isDebugEnabled() && route instanceof OutboundEndpoint) {
                this.logger.debug((Object)("Setting replyTo=" + this.replyTo + " for outbound route: " + ((OutboundEndpoint)route).getEndpointURI()));
            }
        }
        if (this.enableCorrelation != CorrelationMode.NEVER) {
            boolean correlationSet;
            boolean bl = correlationSet = message.getCorrelationId() != null;
            if (correlationSet && this.enableCorrelation == CorrelationMode.IF_NOT_SET) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("CorrelationId is already set to '" + message.getCorrelationId() + "' , not setting it again"));
                }
                return;
            }
            if (correlationSet) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("CorrelationId is already set to '" + message.getCorrelationId() + "', but router is configured to overwrite it"));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No CorrelationId is set on the message, will set a new Id");
            }
            String correlation = service.getMessageInfoMapping().getCorrelationId(message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Extracted correlation Id as: " + correlation));
            }
            if (this.logger.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("Setting Correlation info on Outbound router");
                if (route instanceof OutboundEndpoint) {
                    buf.append(" for endpoint: ").append(((OutboundEndpoint)route).getEndpointURI());
                }
                buf.append(SystemUtils.LINE_SEPARATOR).append("Id=").append(correlation);
                this.logger.debug((Object)buf.toString());
            }
            message.setCorrelationId(correlation);
        }
    }

    @Override
    public List<MessageProcessor> getRoutes() {
        return this.routes;
    }

    @Deprecated
    public void setMessageProcessors(List<MessageProcessor> routes) throws MuleException {
        this.setRoutes(routes);
    }

    public void setRoutes(List<MessageProcessor> routes) throws MuleException {
        this.routes.clear();
        for (MessageProcessor route : routes) {
            this.addRoute(route);
        }
    }

    @Override
    public synchronized void addRoute(MessageProcessor route) throws MuleException {
        if (this.initialised.get()) {
            if (route instanceof MuleContextAware) {
                ((MuleContextAware)((Object)route)).setMuleContext(this.muleContext);
            }
            if (route instanceof FlowConstructAware) {
                ((FlowConstructAware)((Object)route)).setFlowConstruct(this.flowConstruct);
            }
            if (route instanceof Initialisable) {
                ((Initialisable)((Object)route)).initialise();
            }
        }
        if (this.started.get() && route instanceof Startable) {
            ((Startable)((Object)route)).start();
        }
        this.routes.add(route);
    }

    @Override
    public synchronized void removeRoute(MessageProcessor route) throws MuleException {
        if (this.started.get() && route instanceof Stoppable) {
            ((Stoppable)((Object)route)).stop();
        }
        if (this.initialised.get() && route instanceof Disposable) {
            ((Disposable)((Object)route)).dispose();
        }
        this.routes.remove(route);
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    @Override
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public CorrelationMode getEnableCorrelation() {
        return this.enableCorrelation;
    }

    public void setEnableCorrelation(CorrelationMode enableCorrelation) {
        this.enableCorrelation = enableCorrelation;
    }

    public void setEnableCorrelationAsString(String enableCorrelation) {
        if (enableCorrelation != null) {
            if (enableCorrelation.equals("ALWAYS")) {
                this.enableCorrelation = CorrelationMode.ALWAYS;
            } else if (enableCorrelation.equals("NEVER")) {
                this.enableCorrelation = CorrelationMode.NEVER;
            } else if (enableCorrelation.equals("IF_NOT_SET")) {
                this.enableCorrelation = CorrelationMode.IF_NOT_SET;
            } else {
                throw new IllegalArgumentException("Value for enableCorrelation not recognised: " + enableCorrelation);
            }
        }
    }

    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    @Override
    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    @Override
    public boolean isDynamicRoutes() {
        return false;
    }

    public MessageProcessor getRoute(String name) {
        for (MessageProcessor route : this.routes) {
            OutboundEndpoint endpoint;
            if (!(route instanceof OutboundEndpoint) || !(endpoint = (OutboundEndpoint)route).getName().equals(name)) continue;
            return endpoint;
        }
        return null;
    }

    public RouterResultsHandler getResultsHandler() {
        return this.resultsHandler;
    }

    public void setResultsHandler(RouterResultsHandler resultsHandler) {
        this.resultsHandler = resultsHandler;
    }

    protected MuleEvent sendRequestEvent(MuleEvent routedEvent, MuleMessage message, MessageProcessor route, boolean awaitResponse) throws MuleException {
        int timeout;
        if (route == null) {
            throw new DispatchException(CoreMessages.objectIsNull("Outbound Endpoint"), routedEvent, null);
        }
        ImmutableEndpoint endpoint = route instanceof ImmutableEndpoint ? (ImmutableEndpoint)((Object)route) : routedEvent.getEndpoint();
        DefaultMuleEvent event = new DefaultMuleEvent(message, endpoint, routedEvent.getSession(), routedEvent.getProcessingTime());
        if (awaitResponse && (timeout = message.getOutboundProperty("MULE_EVENT_TIMEOUT", -1).intValue()) >= 0) {
            event.setTimeout(timeout);
        }
        return route.process(event);
    }

    protected void propagateMagicProperties(MuleMessage in, MuleMessage out) {
        for (String name : magicProperties) {
            Object value = in.getInboundProperty(name);
            if (value == null) continue;
            out.setOutboundProperty(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        List<MessageProcessor> list = this.routes;
        synchronized (list) {
            for (MessageProcessor processor : this.routes) {
                if (processor instanceof MuleContextAware) {
                    ((MuleContextAware)((Object)processor)).setMuleContext(this.muleContext);
                }
                if (processor instanceof FlowConstructAware) {
                    ((FlowConstructAware)((Object)processor)).setFlowConstruct(this.flowConstruct);
                }
                if (!(processor instanceof Initialisable)) continue;
                ((Initialisable)((Object)processor)).initialise();
            }
            this.initialised.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<MessageProcessor> list = this.routes;
        synchronized (list) {
            for (MessageProcessor processor : this.routes) {
                if (!(processor instanceof Disposable)) continue;
                ((Disposable)((Object)processor)).dispose();
            }
            this.routes = Collections.emptyList();
            this.initialised.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        List<MessageProcessor> list = this.routes;
        synchronized (list) {
            for (MessageProcessor processor : this.routes) {
                if (!(processor instanceof Startable)) continue;
                ((Startable)((Object)processor)).start();
            }
            this.started.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        List<MessageProcessor> list = this.routes;
        synchronized (list) {
            for (MessageProcessor processor : this.routes) {
                if (!(processor instanceof Stoppable)) continue;
                ((Stoppable)((Object)processor)).stop();
            }
            this.started.set(false);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public void setRouterStatistics(RouterStatistics stats) {
        this.routerStatistics = stats;
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }
}

