/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.routing.filter.Filter;
import org.mule.expression.ExpressionConfig;
import org.mule.routing.filters.ExceptionTypeFilter;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.WildcardFilter;
import org.mule.util.ClassUtils;

public class ExpressionFilter
implements Filter,
MuleContextAware {
    protected final transient Log logger = LogFactory.getLog(ExpressionFilter.class);
    private ExpressionConfig config;
    private String fullExpression;
    private boolean nullReturnsTrue = false;
    private MuleContext muleContext;
    private ClassLoader expressionEvaluationClassLoader = Thread.currentThread().getContextClassLoader();
    private Filter delegateFilter;

    public ExpressionFilter(String evaluator, String customEvaluator, String expression) {
        this.config = new ExpressionConfig(expression, evaluator, customEvaluator);
    }

    public ExpressionFilter(String evaluator, String expression) {
        this.config = new ExpressionConfig(expression, evaluator, null);
    }

    public ExpressionFilter(String expression) {
        this.config = new ExpressionConfig();
        this.config.parse(expression);
    }

    public ExpressionFilter() {
        this.config = new ExpressionConfig();
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(MuleMessage message) {
        Object result;
        String expr = this.getFullExpression();
        if (this.delegateFilter != null) {
            boolean result2 = this.delegateFilter.accept(message);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)MessageFormat.format("Result of expression filter: {0} is: {1}", expr, result2));
            }
            return result2;
        }
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.expressionEvaluationClassLoader);
            result = this.muleContext.getExpressionManager().evaluate(expr, message, false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
        if (result == null) {
            return this.nullReturnsTrue;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof String) {
            if (result.toString().toLowerCase().equalsIgnoreCase("false")) {
                return false;
            }
            if (result.toString().toLowerCase().equalsIgnoreCase("true")) {
                return true;
            }
            return !this.nullReturnsTrue;
        }
        this.logger.warn((Object)("Expression: " + expr + ", returned an non-boolean result. Returning: " + !this.nullReturnsTrue));
        return !this.nullReturnsTrue;
    }

    protected String getFullExpression() {
        if (this.fullExpression == null) {
            if (this.config.getEvaluator().equals("header")) {
                this.delegateFilter = new MessagePropertyFilter(this.config.getExpression());
            } else if (this.config.getEvaluator().equals("regex")) {
                this.delegateFilter = new RegExFilter(this.config.getExpression());
            } else if (this.config.getEvaluator().equals("wildcard")) {
                this.delegateFilter = new WildcardFilter(this.config.getExpression());
            } else if (this.config.getEvaluator().equals("payload-type")) {
                try {
                    this.delegateFilter = new PayloadTypeFilter(this.config.getExpression());
                }
                catch (ClassNotFoundException e) {
                    IllegalArgumentException iae = new IllegalArgumentException();
                    iae.initCause(e);
                    throw iae;
                }
            } else if (this.config.getEvaluator().equals("exception-type")) {
                try {
                    this.delegateFilter = new ExceptionTypeFilter(this.config.getExpression());
                }
                catch (ClassNotFoundException e) {
                    IllegalArgumentException iae = new IllegalArgumentException();
                    iae.initCause(e);
                    throw iae;
                }
            } else {
                this.fullExpression = this.config.getFullExpression(this.muleContext.getExpressionManager());
            }
        }
        return this.fullExpression;
    }

    public String getCustomEvaluator() {
        return this.config.getCustomEvaluator();
    }

    public void setCustomEvaluator(String customEvaluator) {
        this.config.setCustomEvaluator(customEvaluator);
        this.fullExpression = null;
    }

    public String getEvaluator() {
        return this.config.getEvaluator();
    }

    public void setEvaluator(String evaluator) {
        this.config.setEvaluator(evaluator);
        this.fullExpression = null;
    }

    public String getExpression() {
        return this.config.getExpression();
    }

    public void setExpression(String expression) {
        this.config.setExpression(expression);
        this.fullExpression = null;
    }

    public boolean isNullReturnsTrue() {
        return this.nullReturnsTrue;
    }

    public void setNullReturnsTrue(boolean nullReturnsTrue) {
        this.nullReturnsTrue = nullReturnsTrue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionFilter other = (ExpressionFilter)obj;
        return ClassUtils.equal(this.config, other.config) && ClassUtils.equal(this.delegateFilter, other.delegateFilter) && this.nullReturnsTrue == other.nullReturnsTrue;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.config, this.delegateFilter, this.nullReturnsTrue});
    }
}

