/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.mule.DefaultMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.routing.outbound.AbstractOutboundRouter;

public class RoundRobin
extends AbstractOutboundRouter
implements MessageProcessor {
    AtomicInteger index = new AtomicInteger(0);

    public MuleEvent route(MuleEvent event) throws MessagingException {
        int index = this.getAndIncrementModuloN(this.routes.size());
        if (index < 0) {
            throw new CouldNotRouteOutboundMessageException(event, this);
        }
        MessageProcessor mp = (MessageProcessor)this.routes.get(index);
        MuleEvent toProcess = event;
        if (mp instanceof OutboundEndpoint) {
            toProcess = new DefaultMuleEvent(event.getMessage(), (OutboundEndpoint)mp, event.getSession());
        }
        try {
            return mp.process(toProcess);
        }
        catch (MuleException ex) {
            throw new RoutingException(event, this, (Throwable)ex);
        }
    }

    private int getAndIncrementModuloN(int modulus) {
        int nextIndex;
        int lastIndex;
        if (modulus == 0) {
            return -1;
        }
        while (!this.index.compareAndSet(lastIndex = this.index.get(), nextIndex = (lastIndex + 1) % modulus)) {
        }
        return nextIndex;
    }

    public boolean isMatch(MuleMessage message) throws MuleException {
        return true;
    }
}

