/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.processor.chain.AbstractMessageProcessorChainBuilder;
import org.mule.processor.chain.DefaultMessageProcessorChain;
import org.mule.processor.chain.InterceptingChainLifecycleWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessageProcessorChainBuilder
extends AbstractMessageProcessorChainBuilder {
    public DefaultMessageProcessorChainBuilder() {
    }

    public DefaultMessageProcessorChainBuilder(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public MessageProcessorChain build() throws MuleException {
        LinkedList<MessageProcessor> tempList = new LinkedList<MessageProcessor>();
        for (int i = this.processors.size() - 1; i >= 0; --i) {
            MessageProcessor processor = this.initializeMessageProcessor(this.processors.get(i));
            if (this.processors.get(i) instanceof InterceptingMessageProcessor) {
                if (i + 1 < this.processors.size()) {
                    if (tempList.isEmpty()) {
                        ((InterceptingMessageProcessor)processor).setListener(this.initializeMessageProcessor(this.processors.get(i + 1)));
                    } else {
                        DefaultMessageProcessorChain chain = new DefaultMessageProcessorChain(this.name, new ArrayList<MessageProcessor>(tempList));
                        ((InterceptingMessageProcessor)processor).setListener(chain);
                    }
                }
                tempList = new LinkedList<MessageProcessor>(Collections.singletonList(processor));
                continue;
            }
            tempList.addFirst(this.initializeMessageProcessor(processor));
        }
        DefaultMessageProcessorChain chain = new DefaultMessageProcessorChain(this.name, new ArrayList<MessageProcessor>(tempList));
        return new InterceptingChainLifecycleWrapper(chain, this.processors, "wrapper for " + this.name);
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(MessageProcessor ... processors) {
        for (MessageProcessor messageProcessor : processors) {
            this.processors.add(messageProcessor);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chain(List<MessageProcessor> processors) {
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(MessageProcessorBuilder ... builders) {
        for (MessageProcessorBuilder messageProcessorBuilder : builders) {
            this.processors.add(messageProcessorBuilder);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(MessageProcessor processor) {
        this.processors.add(0, processor);
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(MessageProcessorBuilder builder) {
        this.processors.add(0, builder);
        return this;
    }
}

