/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.TransformerTemplate;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;

public class InvokerMessageProcessor
implements MessageProcessor,
Initialisable {
    private Object object;
    private String methodName;
    private String[] argumentExpressions;
    private Class<?>[] argumentTypes;
    private String name;
    private Method method;

    public void initialise() throws InitialisationException {
        if (this.argumentTypes != null) {
            this.method = ClassUtils.getMethod(this.object.getClass(), this.methodName, this.argumentTypes);
            if (this.method == null) {
                throw new InitialisationException(CoreMessages.methodWithParamsNotFoundOnObject(this.methodName, this.argumentTypes, this.object.getClass()), (Initialisable)this);
            }
        } else {
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            for (Method methodCandidate : this.object.getClass().getMethods()) {
                if (!methodCandidate.getName().equals(this.methodName) || methodCandidate.getParameterTypes().length != this.argumentExpressions.length) continue;
                matchingMethods.add(methodCandidate);
            }
            if (matchingMethods.size() == 1) {
                this.method = (Method)matchingMethods.get(0);
                this.argumentTypes = this.method.getParameterTypes();
            } else {
                throw new InitialisationException(CoreMessages.methodWithNumParamsNotFoundOnObject(this.methodName, this.argumentExpressions.length, this.object), (Initialisable)this);
            }
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent resultEvent = event;
        Object[] args = this.evaluateArguments(event, this.argumentExpressions);
        try {
            Object result = this.method.invoke(this.object, args);
            if (!this.method.getReturnType().equals(Void.TYPE)) {
                resultEvent = this.createResultEvent(event, result);
            }
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke(this.object.toString()), event, (Throwable)e);
        }
        return resultEvent;
    }

    protected Object[] evaluateArguments(MuleEvent event, String[] expressions) throws MessagingException {
        ExpressionManager expressionManager = event.getMuleContext().getExpressionManager();
        Object[] args = new Object[expressions.length];
        try {
            for (int i = 0; i < args.length; ++i) {
                Object arg = null;
                if (expressions[i] != null) {
                    arg = expressionManager.parse(expressions[i], event.getMessage());
                    if (arg instanceof MuleMessage) {
                        arg = ((MuleMessage)arg).getPayload();
                    }
                    if (!this.argumentTypes[i].isAssignableFrom(arg.getClass())) {
                        DataType<?> source = DataTypeFactory.create(arg.getClass());
                        DataType<?> target = DataTypeFactory.create(this.argumentTypes[i]);
                        Transformer t = event.getMuleContext().getRegistry().lookupTransformer(source, target);
                        arg = t.transform(arg);
                    }
                }
                args[i] = arg;
            }
            return args;
        }
        catch (TransformerException e) {
            throw new MessagingException(event, (Throwable)e);
        }
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setArgumentExpressionsString(String arguments) {
        this.argumentExpressions = arguments.split("\\s*,\\s*");
    }

    public void setArgumentExpressions(String[] argumentExpressions) {
        this.argumentExpressions = argumentExpressions;
    }

    protected MuleEvent createResultEvent(MuleEvent event, Object result) throws MuleException {
        if (result instanceof MuleMessage) {
            return new DefaultMuleEvent((MuleMessage)result, event);
        }
        if (result != null) {
            event.getMessage().applyTransformers(event, Collections.singletonList(new TransformerTemplate(new TransformerTemplate.OverwitePayloadCallback(result))));
            return event;
        }
        return new DefaultMuleEvent(new DefaultMuleMessage(NullPayload.getInstance(), event.getMuleContext()), event);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArgumentTypes(Class[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }
}

