/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.context.notification.MessageProcessorNotification;
import org.mule.util.ObjectUtils;

public abstract class AbstractInterceptingMessageProcessor
implements InterceptingMessageProcessor,
MuleContextAware {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected ServerNotificationHandler notificationHandler;
    private MuleContext muleContext;
    protected MessageProcessor next;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.notificationHandler = this.muleContext.getNotificationManager();
    }

    public void setListener(MessageProcessor next) {
        this.next = next;
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        if (this.next == null) {
            return event;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Invoking next MessageProcessor: '" + this.next.getClass().getName() + "' "));
        }
        this.fireNotification(event, this.next, 1601);
        if (this.next instanceof OutboundEndpoint) {
            event = new DefaultMuleEvent(event.getMessage(), (OutboundEndpoint)this.next, event.getSession());
        }
        MuleEvent result = this.next.process(event);
        this.fireNotification(event, this.next, 1602);
        return result;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }

    protected void fireNotification(MuleEvent event, MessageProcessor processor, int action) {
        if (this.notificationHandler != null && this.notificationHandler.isNotificationEnabled(MessageProcessorNotification.class)) {
            this.notificationHandler.fireNotification(new MessageProcessorNotification(event, processor, action));
        }
    }
}

