/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats.printers;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.mule.management.stats.RouterStatistics;
import org.mule.management.stats.printers.AbstractTablePrinter;
import org.mule.util.StringUtils;

public class XMLPrinter
extends AbstractTablePrinter {
    protected static final int XML_INDENT_SIZE = 2;

    public XMLPrinter(Writer out) {
        super(out);
    }

    public XMLPrinter(OutputStream out) {
        super(out);
    }

    public String[] getHeaders() {
        String[] column = new String[]{"Service Name", "Service Pool Max Size", "Service Pool Size", "Thread Pool Size", "Current Queue Size", "Max Queue Size", "Avg Queue Size", "Sync Events Received", "Async Events Received", "Total Events Received", "Sync Events Sent", "Async Events Sent", "ReplyTo Events Sent", "Total Events Sent", "Executed Events", "Execution Messages", "Fatal Messages", "Min Execution Time", "Max Execution Time", "Avg Execution Time", "Total Execution Time", "Router", "Type", "Total Received", "Total Routed", "Not Routed", "Caught Events", "Providers", "", "Providers", "Router", "Router", "Type", "Total Received", "Total Routed", "Not Routed", "Caught Events", "Providers", "", "Providers", "Router", "Sample Period"};
        return column;
    }

    protected int getRouterInfo(RouterStatistics stats, String[] col, int index) {
        ++index;
        col[index++] = stats.isInbound() ? "Inbound" : "Outbound";
        col[index++] = String.valueOf(stats.getTotalReceived());
        col[index++] = String.valueOf(stats.getTotalRouted());
        col[index++] = String.valueOf(stats.getNotRouted());
        col[index++] = String.valueOf(stats.getCaughtMessages());
        ++index;
        Map routed = stats.getRouted();
        if (!routed.isEmpty()) {
            Iterator it = routed.entrySet().iterator();
            StringBuffer buf = new StringBuffer(40);
            while (it.hasNext()) {
                Map.Entry e = it.next();
                buf.append(e.getKey()).append('=').append(e.getValue());
                if (!it.hasNext()) continue;
                buf.append(';');
            }
            col[index++] = buf.toString();
        } else {
            col[index++] = "";
        }
        return index += 2;
    }

    public void print(Collection stats) {
        this.println("<?xml version=\"1.0\" encoding=\"US-ASCII\"?>");
        this.println("<Components>");
        String[][] table = this.getTable(stats);
        boolean router = false;
        boolean providers = false;
        int indentLevel = 1;
        for (int i = 1; i < table.length; ++i) {
            this.println("<Service name=\"" + table[i][0] + "\">", indentLevel);
            ++indentLevel;
            for (int j = 1; j < table[i].length; ++j) {
                if (StringUtils.equals((String)table[0][j], (String)"Router")) {
                    if (!router) {
                        this.println("<Router type=\"" + table[i][++j] + "\">", indentLevel);
                        ++indentLevel;
                        router = true;
                        continue;
                    }
                    this.println("</Router>", --indentLevel);
                    router = false;
                    continue;
                }
                if (StringUtils.equals((String)table[0][j], (String)"Providers")) {
                    if (StringUtils.isEmpty((String)table[i][j + 1]) && StringUtils.equals((String)table[0][j + 2], (String)"Providers")) {
                        this.println("<Providers/>", indentLevel);
                        j += 2;
                        continue;
                    }
                    if (!providers) {
                        this.println("<Providers>", indentLevel);
                        ++indentLevel;
                        providers = true;
                        continue;
                    }
                    this.println("</Providers>", --indentLevel);
                    providers = false;
                    continue;
                }
                if (providers) {
                    this.printProviderStatsXml(table[i][j], indentLevel);
                    continue;
                }
                this.println("<Statistic name=\"" + table[0][j] + "\" value=\"" + table[i][j] + "\"/>", indentLevel);
            }
            this.println("</Service>", --indentLevel);
        }
        this.println("</Components>", --indentLevel);
    }

    public void println(String s, int indentLevel) {
        String indent = StringUtils.repeat(' ', indentLevel * 2);
        this.println(indent + s);
    }

    protected void printProviderStatsXml(String stats, int indentLevel) {
        if (StringUtils.isBlank((String)stats) || "-".equals(stats)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(stats, ";");
        if (st.countTokens() == 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("<Provider name=\"");
            int i = stats.indexOf("=");
            buf.append(stats.substring(0, i));
            buf.append("\" value=\"");
            buf.append(stats.substring(i + 1));
            buf.append("\"/>");
            this.println(buf.toString(), indentLevel);
        } else {
            while (st.hasMoreTokens()) {
                StringBuffer buf = new StringBuffer();
                String token = st.nextToken();
                buf.append("<Provider name=\"");
                int i = token.indexOf("=");
                buf.append(token.substring(0, i));
                buf.append("\" value=\"");
                buf.append(token.substring(i + 1));
                buf.append("\"/>");
                this.println(buf.toString(), indentLevel);
            }
        }
    }
}

