/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.management.stats.FlowConstructStatistics;

public class ProcessingTime
implements Serializable {
    private static final Log logger = LogFactory.getLog(ProcessingTime.class);
    private static final long TIMER_PERIOD = 30000L;
    private static volatile Timer timer;
    private static ReferenceQueue<ProcessingTime> queue;
    private static Map refs;
    private AtomicLong accumulator = new AtomicLong();
    private FlowConstructStatistics statistics;

    public static ProcessingTime createProcessingTime(MuleSession session) {
        FlowConstructStatistics stats;
        FlowConstruct fc;
        if (session != null && (fc = session.getFlowConstruct()) != null && (stats = fc.getStatistics()) != null && fc.getStatistics().isEnabled()) {
            return new ProcessingTime(stats);
        }
        return null;
    }

    private ProcessingTime(FlowConstructStatistics stats) {
        this.statistics = stats;
        if (timer == null) {
            ProcessingTime.startTimer();
        }
        refs.put(new Reference(this), refs);
    }

    public void addFlowExecutionBranchTime(long startTime) {
        if (this.statistics.isEnabled()) {
            long elapsedTime = ProcessingTime.getEffectiveTime(System.currentTimeMillis() - startTime);
            this.statistics.addFlowExecutionBranchTime(elapsedTime, this.accumulator.addAndGet(elapsedTime));
        }
    }

    public static long getEffectiveTime(long time) {
        return time <= 0L ? 1L : time;
    }

    public static synchronized void startTimer() {
        if (timer == null) {
            timer = new Timer("ProcessingTimeMonitor", true);
            timer.schedule(new TimerTask(){

                public void run() {
                    try {
                        Reference ref;
                        do {
                            java.lang.ref.Reference temp;
                            if ((ref = (Reference)(temp = queue.poll())) == null) continue;
                            refs.remove(ref);
                            FlowConstructStatistics stats = ref.getStatistics();
                            if (!stats.isEnabled()) continue;
                            stats.addCompleteFlowExecutionTime(ref.getAccumulator().longValue());
                        } while (ref != null);
                    }
                    catch (Exception ex) {
                        logger.error((Object)this, (Throwable)ex);
                    }
                }
            }, 30000L, 30000L);
        }
    }

    public static synchronized void stopTimer() {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        refs.clear();
    }

    static {
        queue = new ReferenceQueue();
        refs = new ConcurrentHashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Reference
    extends WeakReference<ProcessingTime> {
        private FlowConstructStatistics statistics;
        private AtomicLong accumulator;

        Reference(ProcessingTime time) {
            super(time, queue);
            this.statistics = time.statistics;
            this.accumulator = time.accumulator;
        }

        public AtomicLong getAccumulator() {
            return this.accumulator;
        }

        public FlowConstructStatistics getStatistics() {
            return this.statistics;
        }
    }
}

