/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.management.stats.ProcessingTime;
import org.mule.management.stats.printers.AbstractTablePrinter;
import org.mule.management.stats.printers.SimplePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllStatistics {
    private boolean isStatisticsEnabled;
    private long startTime;
    private Map<String, FlowConstructStatistics> flowConstructStats = new HashMap<String, FlowConstructStatistics>();

    public AllStatistics() {
        this.clear();
    }

    public void logSummary() {
        this.logSummary(new SimplePrinter(System.out));
    }

    public void logSummary(PrintWriter printer) {
        if (printer instanceof AbstractTablePrinter) {
            printer.print(this.flowConstructStats.values());
        } else {
            for (FlowConstructStatistics statistics : this.flowConstructStats.values()) {
                printer.print(statistics);
            }
        }
    }

    public synchronized void clear() {
        for (FlowConstructStatistics statistics : this.getServiceStatistics()) {
            statistics.clear();
        }
        this.startTime = System.currentTimeMillis();
    }

    public boolean isEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setEnabled(boolean b) {
        this.isStatisticsEnabled = b;
        for (FlowConstructStatistics statistics : this.flowConstructStats.values()) {
            statistics.setEnabled(b);
        }
        if (!b) {
            ProcessingTime.stopTimer();
        }
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized void add(FlowConstructStatistics stat) {
        if (stat != null) {
            this.flowConstructStats.put(stat.getName(), stat);
        }
    }

    public synchronized void remove(FlowConstructStatistics stat) {
        if (stat != null) {
            this.flowConstructStats.remove(stat.getName());
        }
    }

    @Deprecated
    public synchronized Collection<FlowConstructStatistics> getComponentStatistics() {
        return this.flowConstructStats.values();
    }

    public synchronized Collection<FlowConstructStatistics> getServiceStatistics() {
        return this.flowConstructStats.values();
    }
}

