/*
 * Decompiled with CFR 0.152.
 */
package org.mule.exception;

import java.util.List;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.ExceptionHelper;
import org.mule.exception.AbstractMessagingExceptionStrategy;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.management.stats.ServiceStatistics;
import org.mule.util.CollectionUtils;

public class DefaultServiceExceptionStrategy
extends AbstractMessagingExceptionStrategy {
    public DefaultServiceExceptionStrategy() {
    }

    public DefaultServiceExceptionStrategy(MuleContext muleContext) {
        this.setMuleContext(muleContext);
    }

    protected void defaultHandler(Throwable t) {
        FlowConstructStatistics statistics = this.getFlowConstructStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incExecutionError();
        }
        super.defaultHandler(DefaultMuleConfiguration.fullStackTraces ? t : ExceptionHelper.sanitize(t));
    }

    protected void logFatal(MuleMessage message, Throwable t) {
        FlowConstructStatistics statistics = this.getFlowConstructStatistics();
        if (statistics != null && statistics.isEnabled()) {
            statistics.incFatalError();
        }
        super.logFatal(message, t);
    }

    protected void routeException(MuleMessage message, MessageProcessor target, Throwable t) {
        ServiceStatistics statistics;
        super.routeException(message, target, t);
        List<MessageProcessor> processors = this.getMessageProcessors(t);
        if (CollectionUtils.isNotEmpty(processors) && this.getFlowConstructStatistics() instanceof ServiceStatistics && (statistics = this.getServiceStatistics()).isEnabled()) {
            for (MessageProcessor endpoint : processors) {
                statistics.getOutboundRouterStat().incrementRoutedMessage(endpoint);
            }
        }
    }

    protected FlowConstructStatistics getFlowConstructStatistics() {
        MuleEvent event = RequestContext.getEvent();
        if (event == null) {
            this.logger.fatal((Object)"The Default Service Exception Strategy has been invoked but there is no current event on the context");
            return null;
        }
        if (event.getFlowConstruct() != null) {
            return event.getFlowConstruct().getStatistics();
        }
        this.logger.fatal((Object)"The Default Service Exception Strategy has been invoked but there is no current flow construct on the context. Please report this to dev@mule.codehaus.org");
        return null;
    }

    protected ServiceStatistics getServiceStatistics() {
        FlowConstructStatistics stats = this.getFlowConstructStatistics();
        if (!(stats instanceof ServiceStatistics)) {
            this.logger.fatal((Object)"The Default Service Exception Strategy has been invoked but there is no current service on the context. Please report this to dev@mule.codehaus.org");
            return null;
        }
        return (ServiceStatistics)stats;
    }
}

