/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transport.Connector;
import org.mule.endpoint.AbstractEndpoint;
import org.mule.transport.AbstractConnector;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOutboundEndpoint
extends AbstractEndpoint
implements OutboundEndpoint {
    private static final long serialVersionUID = 8860985949279708638L;
    private List<String> responseProperties = new ArrayList<String>();

    public DefaultOutboundEndpoint(Connector connector, EndpointURI endpointUri, String name, Map properties, TransactionConfig transactionConfig, boolean deleteUnacceptedMessage, MessageExchangePattern messageExchangePattern, int responseTimeout, String initialState, String endpointEncoding, String endpointBuilderName, MuleContext muleContext, RetryPolicyTemplate retryPolicyTemplate, String responsePropertiesList, EndpointMessageProcessorChainFactory messageProcessorsFactory, List<MessageProcessor> messageProcessors, List<MessageProcessor> responseMessageProcessors, boolean disableTransportTransformer, String endpointMimeType) {
        super(connector, endpointUri, name, properties, transactionConfig, deleteUnacceptedMessage, messageExchangePattern, responseTimeout, initialState, endpointEncoding, endpointBuilderName, muleContext, retryPolicyTemplate, messageProcessorsFactory, messageProcessors, responseMessageProcessors, disableTransportTransformer, endpointMimeType);
        this.responseProperties.add("MULE_CORRELATION_ID");
        this.responseProperties.add("MULE_CORRELATION_GROUP_SIZE");
        this.responseProperties.add("MULE_CORRELATION_SEQUENCE");
        this.responseProperties.add("MULE_SESSION");
        String[] props = StringUtils.splitAndTrim(responsePropertiesList, ",");
        if (props != null) {
            this.responseProperties.addAll(Arrays.asList(props));
        }
    }

    @Override
    public List<String> getResponseProperties() {
        return this.responseProperties;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        return this.getMessageProcessorChain(event.getFlowConstruct()).process(event);
    }

    @Override
    protected MessageProcessor createMessageProcessorChain(FlowConstruct flowContruct) throws MuleException {
        EndpointMessageProcessorChainFactory factory = this.getMessageProcessorsFactory();
        MessageProcessor chain = factory.createOutboundMessageProcessorChain(this, flowContruct, ((AbstractConnector)this.getConnector()).createDispatcherMessageProcessor(this));
        if (chain instanceof MuleContextAware) {
            ((MuleContextAware)((Object)chain)).setMuleContext(this.getMuleContext());
        }
        if (chain instanceof FlowConstructAware) {
            ((FlowConstructAware)((Object)chain)).setFlowConstruct(flowContruct);
        }
        if (chain instanceof Initialisable) {
            ((Initialisable)((Object)chain)).initialise();
        }
        return chain;
    }
}

