/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import java.lang.reflect.Method;
import org.mule.api.MuleEvent;
import org.mule.api.MuleRuntimeException;
import org.mule.api.NamedObject;
import org.mule.api.context.notification.BlockingServerEvent;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.ObjectUtils;

public class MessageProcessorNotification
extends ServerNotification
implements BlockingServerEvent {
    private static final long serialVersionUID = 1L;
    public static final int MESSAGE_PROCESSOR_PRE_INVOKE = 1601;
    public static final int MESSAGE_PROCESSOR_POST_INVOKE = 1602;
    private final transient MessageProcessor processor;
    private final String messageProcessorName;

    public MessageProcessorNotification(MuleEvent event, MessageProcessor processor, int action) {
        super(event, action, event.getFlowConstruct() != null ? event.getFlowConstruct().getName() : null);
        this.processor = processor;
        try {
            Method method = processor.getClass().getMethod("getName", new Class[0]);
            this.messageProcessorName = method == null ? this.toString(processor) : ObjectUtils.toString((Object)method.invoke((Object)processor, new Object[0]), (String)this.toString(processor));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    public MuleEvent getSource() {
        return (MuleEvent)super.getSource();
    }

    public MessageProcessor getProcessor() {
        return this.processor;
    }

    public String getFriendlyProcessorName() {
        return this.messageProcessorName;
    }

    protected String toString(Object obj) {
        if (obj == null) {
            return "";
        }
        String name = obj instanceof NamedObject ? String.format("%s '%s'", obj.getClass().getName(), ((NamedObject)obj).getName()) : ObjectUtils.identityToString((Object)obj);
        return name;
    }

    static {
        MessageProcessorNotification.registerAction("message processor pre invoke", 1601);
        MessageProcessorNotification.registerAction("message processor post invoke", 1602);
    }
}

