/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingException;
import org.mule.api.config.ExceptionReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingExceptionReader
implements ExceptionReader {
    protected static final String MISSING_NAME_DISPLAY_VALUE = "<none>";

    @Override
    public String getMessage(Throwable t) {
        return t instanceof NamingException ? ((NamingException)t).toString(true) : "<unknown>";
    }

    @Override
    public Throwable getCause(Throwable t) {
        return t instanceof NamingException ? ((NamingException)t).getCause() : null;
    }

    @Override
    public Class<?> getExceptionType() {
        return NamingException.class;
    }

    @Override
    public Map<?, ?> getInfo(Throwable t) {
        if (t instanceof NamingException) {
            NamingException e = (NamingException)t;
            HashMap<String, String> info = new HashMap<String, String>();
            Name remainingName = e.getRemainingName();
            Name resolvedName = e.getResolvedName();
            info.put("Remaining Name", remainingName == null ? MISSING_NAME_DISPLAY_VALUE : remainingName.toString());
            info.put("Resolved Name", resolvedName == null ? MISSING_NAME_DISPLAY_VALUE : resolvedName.toString());
            return info;
        }
        return Collections.EMPTY_MAP;
    }
}

