/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.InputStream;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class StringToObjectArray
extends AbstractTransformer {
    private String delimiter = null;
    private static final String DEFAULT_DELIMITER = " ";

    public StringToObjectArray() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.create(Object[].class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        String in;
        if (src instanceof byte[]) {
            in = new String((byte[])src);
        } else if (src instanceof InputStream) {
            InputStream input = (InputStream)src;
            try {
                in = IOUtils.toString(input);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        } else {
            in = (String)src;
        }
        String[] out = StringUtils.splitAndTrim(in, this.getDelimiter());
        return out;
    }

    public String getDelimiter() {
        if (this.delimiter == null) {
            return DEFAULT_DELIMITER;
        }
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

