/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageRouter;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutingException;
import org.mule.routing.CorrelationMode;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.routing.outbound.SplitMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageSplitter
extends FilteringOutboundRouter
implements MessageRouter {
    @Override
    public MuleEvent route(MuleEvent event) throws RoutingException {
        MuleMessage message = event.getMessage();
        String correlationId = event.getFlowConstruct().getMessageInfoMapping().getCorrelationId(message);
        ArrayList<MuleEvent> results = new ArrayList<MuleEvent>();
        int correlationSequence = 1;
        SplitMessage splitMessage = this.getMessageParts(message, this.getRoutes());
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String propertyKey : message.getOutboundPropertyNames()) {
            Object value = message.getOutboundProperty(propertyKey);
            if (value == null) continue;
            props.put(propertyKey, value);
        }
        for (int i = 0; i < splitMessage.size(); ++i) {
            SplitMessage.MessagePart part = splitMessage.getPart(i);
            MuleMessage sendMessage = part.getPart() instanceof MuleMessage ? (MuleMessage)part.getPart() : new DefaultMuleMessage(part.getPart(), props, this.muleContext);
            try {
                if (this.enableCorrelation != CorrelationMode.NEVER) {
                    boolean correlationSet;
                    boolean bl = correlationSet = message.getCorrelationId() != null;
                    if (!correlationSet && this.enableCorrelation == CorrelationMode.IF_NOT_SET) {
                        sendMessage.setCorrelationId(correlationId);
                    }
                    sendMessage.setCorrelationGroupSize(splitMessage.size());
                    sendMessage.setCorrelationSequence(correlationSequence++);
                }
                if (part.getEndpoint().getExchangePattern().hasResponse()) {
                    results.add(this.sendRequest(event, sendMessage, part.getEndpoint(), true));
                    continue;
                }
                this.sendRequest(event, sendMessage, part.getEndpoint(), false);
                continue;
            }
            catch (MuleException e) {
                throw new CouldNotRouteOutboundMessageException(event, (MessageProcessor)part.getEndpoint(), (Throwable)e);
            }
        }
        return this.resultsHandler.aggregateResults(results, event, this.muleContext);
    }

    protected abstract SplitMessage getMessageParts(MuleMessage var1, List<MessageProcessor> var2);
}

