/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import java.io.PrintWriter;
import org.mule.management.stats.ComponentStatistics;
import org.mule.management.stats.FlowConstructStatistics;
import org.mule.management.stats.QueueStatistics;
import org.mule.management.stats.RouterStatistics;
import org.mule.management.stats.printers.SimplePrinter;

public class ServiceStatistics
extends FlowConstructStatistics
implements QueueStatistics {
    private static final long serialVersionUID = -2086999226732861675L;
    private final AtomicLong sentEventSync = new AtomicLong(0L);
    private final AtomicLong sentReplyToEvent = new AtomicLong(0L);
    private final AtomicLong sentEventASync = new AtomicLong(0L);
    private final AtomicLong executionError = new AtomicLong(0L);
    private final AtomicLong fatalError = new AtomicLong(0L);
    private long queuedEvent = 0L;
    private long maxQueuedEvent = 0L;
    private long averageQueueSize = 0L;
    private long totalQueuedEvent = 0L;
    private int threadPoolSize = 0;
    private long samplePeriod = 0L;
    private RouterStatistics inboundRouterStat = null;
    private ComponentStatistics componentStat = null;
    private RouterStatistics outboundRouterStat = null;

    public ServiceStatistics(String name) {
        this(name, 0);
    }

    public ServiceStatistics(String name, int threadPoolSize) {
        super(name);
        this.threadPoolSize = threadPoolSize;
        this.clear();
    }

    public synchronized void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.inboundRouterStat != null) {
            this.inboundRouterStat.setEnabled(b);
        }
        if (this.componentStat != null) {
            this.componentStat.setEnabled(b);
        }
        if (this.outboundRouterStat != null) {
            this.outboundRouterStat.setEnabled(b);
        }
    }

    public void incExecutionError() {
        this.executionError.addAndGet(1L);
    }

    public void incFatalError() {
        this.fatalError.addAndGet(1L);
    }

    public void incSentEventSync() {
        this.sentEventSync.addAndGet(1L);
    }

    public void incSentEventASync() {
        this.sentEventASync.addAndGet(1L);
    }

    public void incSentReplyToEvent() {
        this.sentReplyToEvent.addAndGet(1L);
    }

    public synchronized void incQueuedEvent() {
        ++this.queuedEvent;
        ++this.totalQueuedEvent;
        if (this.queuedEvent > this.maxQueuedEvent) {
            this.maxQueuedEvent = this.queuedEvent;
        }
        this.averageQueueSize = this.receivedEventASync.get() / this.totalQueuedEvent;
    }

    public synchronized void decQueuedEvent() {
        --this.queuedEvent;
    }

    public long getAverageExecutionTime() {
        return this.componentStat.getAverageExecutionTime();
    }

    public synchronized long getAverageQueueSize() {
        return this.averageQueueSize;
    }

    public synchronized long getMaxQueueSize() {
        return this.maxQueuedEvent;
    }

    @Deprecated
    public long getMaxExecutionTime() {
        return this.componentStat.getMaxExecutionTime();
    }

    public long getFatalErrors() {
        return this.fatalError.get();
    }

    @Deprecated
    public long getMinExecutionTime() {
        return this.componentStat.getMinExecutionTime();
    }

    @Deprecated
    public long getTotalExecutionTime() {
        return this.componentStat.getTotalExecutionTime();
    }

    public synchronized long getQueuedEvents() {
        return this.queuedEvent;
    }

    public long getReplyToEventsSent() {
        return this.sentReplyToEvent.get();
    }

    public long getSyncEventsSent() {
        return this.sentEventSync.get();
    }

    public long getAsyncEventsSent() {
        return this.sentEventASync.get();
    }

    public long getTotalEventsSent() {
        return this.getSyncEventsSent() + this.getAsyncEventsSent();
    }

    public long getTotalEventsReceived() {
        return this.getSyncEventsReceived() + this.getAsyncEventsReceived();
    }

    public long getExecutedEvents() {
        return this.componentStat.getExecutedEvents();
    }

    public long getExecutionErrors() {
        return this.executionError.get();
    }

    public void logSummary() {
        this.logSummary(new SimplePrinter(System.out));
    }

    public void logSummary(PrintWriter printer) {
        printer.print(this);
    }

    public synchronized void clear() {
        super.clear();
        this.queuedEvent = 0L;
        this.maxQueuedEvent = 0L;
        this.totalQueuedEvent = 0L;
        this.averageQueueSize = 0L;
        this.sentEventSync.set(0L);
        this.sentEventASync.set(0L);
        this.sentReplyToEvent.set(0L);
        this.executionError.set(0L);
        this.fatalError.set(0L);
        if (this.getInboundRouterStat() != null) {
            this.getInboundRouterStat().clear();
        }
        if (this.getOutboundRouterStat() != null) {
            this.getOutboundRouterStat().clear();
        }
        this.samplePeriod = System.currentTimeMillis();
    }

    public RouterStatistics getInboundRouterStat() {
        return this.inboundRouterStat;
    }

    public void setInboundRouterStat(RouterStatistics inboundRouterStat) {
        this.inboundRouterStat = inboundRouterStat;
        this.inboundRouterStat.setEnabled(this.enabled);
    }

    public RouterStatistics getOutboundRouterStat() {
        return this.outboundRouterStat;
    }

    public void setOutboundRouterStat(RouterStatistics outboundRouterStat) {
        this.outboundRouterStat = outboundRouterStat;
        this.outboundRouterStat.setEnabled(this.enabled);
    }

    public ComponentStatistics getComponentStat() {
        return this.componentStat;
    }

    public void setComponentStat(ComponentStatistics componentStat) {
        this.componentStat = componentStat;
        this.componentStat.setEnabled(this.enabled);
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public long getSamplePeriod() {
        return System.currentTimeMillis() - this.samplePeriod;
    }
}

