/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.expression.InvalidExpressionException;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.lifecycle.Disposable;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.TemplateParser;

public class DefaultExpressionManager
implements ExpressionManager,
MuleContextAware {
    protected static final transient Log logger = LogFactory.getLog(DefaultExpressionManager.class);
    private TemplateParser parser = TemplateParser.createMuleStyleParser();
    private ConcurrentMap evaluators = new ConcurrentHashMap(8);
    private MuleContext muleContext;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void registerEvaluator(ExpressionEvaluator evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("evaluator").getMessage());
        }
        String name = evaluator.getName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Evaluators already contain an object named '" + name + "'.  The previous object will be overwritten."));
        }
        this.evaluators.put((Object)evaluator.getName(), (Object)evaluator);
    }

    public boolean isEvaluatorRegistered(String name) {
        return this.evaluators.containsKey((Object)name);
    }

    public ExpressionEvaluator unregisterEvaluator(String name) {
        if (name == null) {
            return null;
        }
        ExpressionEvaluator evaluator = (ExpressionEvaluator)this.evaluators.remove((Object)name);
        if (evaluator instanceof Disposable) {
            ((Disposable)((Object)evaluator)).dispose();
        }
        return evaluator;
    }

    public Object evaluate(String expression, MuleMessage message) throws ExpressionRuntimeException {
        return this.evaluate(expression, message, false);
    }

    public Object evaluate(String expression, MuleMessage message, boolean failIfNull) throws ExpressionRuntimeException {
        String name;
        int i;
        if (expression == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("expression").getMessage());
        }
        if (expression.startsWith("#[")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if ((i = expression.indexOf(":")) > -1) {
            name = expression.substring(0, i);
            expression = expression.substring(i + "]".length());
        } else {
            name = expression;
            expression = null;
        }
        return this.evaluate(expression, name, message, failIfNull);
    }

    public Object evaluate(String expression, String evaluator, MuleMessage message, boolean failIfNull) throws ExpressionRuntimeException {
        ExpressionEvaluator extractor = (ExpressionEvaluator)this.evaluators.get((Object)evaluator);
        if (extractor == null) {
            throw new IllegalArgumentException(CoreMessages.expressionEvaluatorNotRegistered(evaluator).getMessage());
        }
        Object result = extractor.evaluate(expression, message);
        if (failIfNull && result == null) {
            throw new RequiredValueException(CoreMessages.expressionEvaluatorReturnedNull(evaluator, expression));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("Result of expression: {0}:{1} is: {2}", evaluator, expression, result));
        }
        return result;
    }

    public String parse(String expression, MuleMessage message) throws ExpressionRuntimeException {
        return this.parse(expression, message, false);
    }

    public String parse(String expression, final MuleMessage message, final boolean failIfNull) throws ExpressionRuntimeException {
        return this.parser.parse(new TemplateParser.TemplateCallback(){

            public Object match(String token) {
                return DefaultExpressionManager.this.evaluate(token, message, failIfNull);
            }
        }, expression);
    }

    public synchronized void clearEvaluators() {
        for (ExpressionEvaluator evaluator : this.evaluators.values()) {
            if (!(evaluator instanceof Disposable)) continue;
            ((Disposable)((Object)evaluator)).dispose();
        }
        this.evaluators.clear();
    }

    public boolean isExpression(String string) {
        return string.contains("#[");
    }

    public boolean isValidExpression(String expression) {
        try {
            this.validateExpression(expression);
            return true;
        }
        catch (InvalidExpressionException e) {
            logger.warn((Object)e.getMessage());
            return false;
        }
    }

    public void validateExpression(String expression) throws InvalidExpressionException {
        if (!this.muleContext.getConfiguration().isValidateExpressions()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Validate expressions is turned off, no checking done for: " + expression));
            }
            return;
        }
        try {
            this.parser.validate(expression);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidExpressionException(expression, e.getMessage());
        }
        final AtomicBoolean valid = new AtomicBoolean(true);
        final AtomicBoolean match = new AtomicBoolean(false);
        final StringBuffer message = new StringBuffer();
        this.parser.parse(new TemplateParser.TemplateCallback(){

            public Object match(String token) {
                match.set(true);
                if (token.indexOf(":") == -1) {
                    if (valid.get()) {
                        valid.compareAndSet(true, false);
                    }
                    message.append(token).append(" is invalid\n");
                }
                return null;
            }
        }, expression);
        if (message.length() > 0) {
            throw new InvalidExpressionException(expression, message.toString());
        }
        if (!match.get()) {
            throw new InvalidExpressionException(expression, "Expression string is not an expression.  Use isExpression(String) to validate first");
        }
    }
}

