/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct.builder;

import java.util.List;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.AbstractFlowConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlowConstructBuilder<T extends AbstractFlowConstructBuilder, F extends AbstractFlowConstruct> {
    private MessagingExceptionHandler exceptionListener;
    private InboundEndpoint inboundEndpoint;
    private EndpointBuilder inboundEndpointBuilder;
    private String inboundAddress;
    protected String name;
    protected List<MessageProcessor> inboundTransformers;
    protected List<MessageProcessor> inboundResponseTransformers;

    public T name(String name) {
        this.name = name;
        return (T)this;
    }

    public T exceptionStrategy(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
        return (T)this;
    }

    public T inboundEndpoint(InboundEndpoint inboundEndpoint) {
        this.inboundEndpoint = inboundEndpoint;
        return (T)this;
    }

    public T inboundEndpoint(EndpointBuilder inboundEndpointBuilder) {
        this.inboundEndpointBuilder = inboundEndpointBuilder;
        return (T)this;
    }

    public T inboundAddress(String inboundAddress) {
        this.inboundAddress = inboundAddress;
        return (T)this;
    }

    public F build(MuleContext muleContext) throws MuleException {
        F flowConstruct = this.buildFlowConstruct(muleContext);
        this.addExceptionListener((AbstractFlowConstruct)flowConstruct);
        return flowConstruct;
    }

    protected abstract F buildFlowConstruct(MuleContext var1) throws MuleException;

    protected void addExceptionListener(AbstractFlowConstruct flowConstruct) {
        if (this.exceptionListener != null) {
            flowConstruct.setExceptionListener(this.exceptionListener);
        }
    }

    protected InboundEndpoint getOrBuildInboundEndpoint(MuleContext muleContext) throws MuleException {
        if (this.inboundEndpoint != null) {
            return this.inboundEndpoint;
        }
        if (this.inboundEndpointBuilder == null) {
            this.inboundEndpointBuilder = muleContext.getRegistry().lookupEndpointFactory().getEndpointBuilder(this.inboundAddress);
        }
        this.inboundEndpointBuilder.setExchangePattern(this.getInboundMessageExchangePattern());
        if (this.inboundTransformers != null) {
            this.inboundEndpointBuilder.setMessageProcessors(this.inboundTransformers);
        }
        if (this.inboundResponseTransformers != null) {
            this.inboundEndpointBuilder.setResponseMessageProcessors(this.inboundResponseTransformers);
        }
        this.doConfigureInboundEndpointBuilder(muleContext, this.inboundEndpointBuilder);
        return this.inboundEndpointBuilder.buildInboundEndpoint();
    }

    protected abstract MessageExchangePattern getInboundMessageExchangePattern();

    protected void doConfigureInboundEndpointBuilder(MuleContext muleContext, EndpointBuilder endpointBuilder) {
    }
}

