/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import org.apache.commons.lang.Validate;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.processor.FlowConstructStatisticsMessageObserver;
import org.mule.expression.ExpressionConfig;
import org.mule.expression.transformers.ExpressionArgument;
import org.mule.expression.transformers.ExpressionTransformer;
import org.mule.interceptor.LoggingInterceptor;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.ResponseMessageProcessorAdapter;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.mule.routing.ChoiceRouter;

public class Validator
extends AbstractFlowConstruct {
    private final OutboundEndpoint outboundEndpoint;
    private final Filter validationFilter;
    private final String ackExpression;
    private final String nackExpression;

    public Validator(String name, MuleContext muleContext, MessageSource messageSource, OutboundEndpoint outboundEndpoint, Filter validationFilter, String ackExpression, String nackExpression) {
        super(name, muleContext);
        Validate.notNull((Object)messageSource, (String)"messageSource can't be null");
        Validate.notNull((Object)outboundEndpoint, (String)"outboundEndpoint can't be null");
        Validate.notNull((Object)validationFilter, (String)"validationFilter can't be null");
        Validate.notEmpty((String)ackExpression, (String)"ackExpression can't be empty");
        Validate.notEmpty((String)nackExpression, (String)"nackExpression can't be empty");
        this.messageSource = messageSource;
        this.outboundEndpoint = outboundEndpoint;
        this.validationFilter = validationFilter;
        this.ackExpression = ackExpression;
        this.nackExpression = nackExpression;
    }

    protected void configureMessageProcessors(InterceptingChainMessageProcessorBuilder builder) {
        builder.chain(new LoggingInterceptor());
        builder.chain(new FlowConstructStatisticsMessageObserver());
        EventReturningMessageProcessor outboundMessageProcessor = new EventReturningMessageProcessor();
        outboundMessageProcessor.setListener(this.outboundEndpoint);
        ResponseMessageProcessorAdapter ackResponseMessageProcessor = new ResponseMessageProcessorAdapter();
        ackResponseMessageProcessor.setListener(outboundMessageProcessor);
        ackResponseMessageProcessor.setProcessor(this.getExpressionTransformer(this.getName() + "-ack-expression", this.ackExpression));
        ChoiceRouter choiceRouter = new ChoiceRouter();
        choiceRouter.addRoute(ackResponseMessageProcessor, this.validationFilter);
        choiceRouter.setDefaultRoute(this.getExpressionTransformer(this.getName() + "-nack-expression", this.nackExpression));
        builder.chain(choiceRouter);
    }

    protected void validateConstruct() throws FlowConstructInvalidException {
        super.validateConstruct();
        this.validateMessageSource();
        this.validateOutboundEndpoint();
        this.validateExpression(this.ackExpression);
        this.validateExpression(this.nackExpression);
    }

    private void validateMessageSource() throws FlowConstructInvalidException {
        if (this.messageSource instanceof InboundEndpoint && !((InboundEndpoint)this.messageSource).getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("Validator only works with a request-response inbound endpoint."), this);
        }
    }

    private void validateOutboundEndpoint() throws FlowConstructInvalidException {
        if (!this.outboundEndpoint.getExchangePattern().equals((Object)MessageExchangePattern.ONE_WAY)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("Validator only works with a one-way outbound endpoint."), this);
        }
    }

    private void validateExpression(String expression) throws FlowConstructInvalidException {
        if (!this.muleContext.getExpressionManager().isExpression(expression)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("Invalid expression in Validator: " + expression), this);
        }
    }

    private ExpressionTransformer getExpressionTransformer(String name, String expression) {
        ExpressionConfig expressionConfig = new ExpressionConfig();
        expressionConfig.parse(expression);
        ExpressionArgument expressionArgument = new ExpressionArgument(name, expressionConfig, false);
        expressionArgument.setMuleContext(this.muleContext);
        ExpressionTransformer expressionTransformer = new ExpressionTransformer();
        expressionTransformer.setMuleContext(this.muleContext);
        expressionTransformer.addArgument(expressionArgument);
        try {
            expressionTransformer.initialise();
        }
        catch (InitialisationException ie) {
            throw new MuleRuntimeException(ie);
        }
        return expressionTransformer;
    }

    private static class EventReturningMessageProcessor
    extends AbstractInterceptingMessageProcessor {
        private EventReturningMessageProcessor() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            super.processNext(event);
            return RequestContext.cloneAndUpdateEventEndpoint(event, this);
        }
    }
}

