/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class SerializableToByteArray
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public SerializableToByteArray() {
        this.registerSourceType(Serializable.class);
        this.setReturnDataType(DataTypeFactory.create(byte[].class));
    }

    public boolean isAcceptMuleMessage() {
        return this.isSourceTypeSupported(MuleMessage.class, true);
    }

    public void setAcceptMuleMessage(boolean value) {
        if (value) {
            this.registerSourceType(MuleMessage.class);
        } else {
            this.unregisterSourceType(MuleMessage.class);
        }
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            return SerializationUtils.serialize((Serializable)((Serializable)src));
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

