/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.processor;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.BooleanUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.service.Service;
import org.mule.api.transport.ReplyToHandler;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transport.AbstractConnector;

public class ServiceInternalMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected Service service;
    protected MessageProcessor receiveAsyncReplyMessageProcessor;
    private AtomicReference<ReplyToHandler> cachedReplyToHandler = new AtomicReference();

    public ServiceInternalMessageProcessor(Service service) {
        this.service = service;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent resultEvent = null;
        try {
            Object replyTo = event.getMessage().getReplyTo();
            ReplyToHandler replyToHandler = this.getReplyToHandler(event.getMessage(), event.getEndpoint());
            event.getMessage().setReplyTo(null);
            resultEvent = this.service.getComponent().process(event);
            resultEvent = this.processNext(resultEvent);
            if (resultEvent != null) {
                String replyToStop = (String)resultEvent.getMessage().getInvocationProperty("MULE_REPLYTO_STOP");
                if (!event.getEndpoint().getExchangePattern().hasResponse() || !BooleanUtils.toBoolean((String)replyToStop)) {
                    this.processReplyTo(event, resultEvent, replyToHandler, replyTo);
                }
            }
            return resultEvent;
        }
        catch (Exception e) {
            event.getSession().setValid(false);
            if (e instanceof MuleException) {
                throw (MuleException)e;
            }
            throw new MessagingException(event, (Throwable)e);
        }
    }

    protected ReplyToHandler getReplyToHandler(MuleMessage message, ImmutableEndpoint endpoint) {
        Object replyTo = message.getReplyTo();
        if (replyTo != null) {
            if (this.cachedReplyToHandler.get() == null) {
                ReplyToHandler replyToHandler = ((AbstractConnector)endpoint.getConnector()).getReplyToHandler(endpoint);
                if (endpoint.getResponseTransformers() != null) {
                    replyToHandler.setTransformers(endpoint.getResponseTransformers());
                }
                this.cachedReplyToHandler.compareAndSet(null, replyToHandler);
            }
            return this.cachedReplyToHandler.get();
        }
        return null;
    }

    protected void processReplyTo(MuleEvent event, MuleEvent result, ReplyToHandler replyToHandler, Object replyTo) throws MuleException {
        String requestor;
        if (result != null && replyToHandler != null && ((requestor = (String)result.getMessage().getOutboundProperty("MULE_REPLYTO_REQUESTOR")) != null && !requestor.equals(this.service.getName()) || requestor == null)) {
            replyToHandler.processReplyTo(event, result.getMessage(), replyTo);
        }
    }
}

