/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model;

import java.util.Properties;
import org.mule.api.model.Model;
import org.mule.api.model.ModelServiceDescriptor;
import org.mule.api.registry.AbstractServiceDescriptor;
import org.mule.api.registry.ServiceException;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelServiceDescriptor
extends AbstractServiceDescriptor
implements ModelServiceDescriptor {
    private String modelClass;
    private Properties properties;

    public DefaultModelServiceDescriptor(String service, Properties properties) {
        super(service);
        this.properties = properties;
        this.modelClass = this.removeProperty("model", properties);
    }

    @Override
    public Model createModel() throws ServiceException {
        if (this.modelClass != null) {
            try {
                Model model = (Model)ClassUtils.instanciateClass(this.modelClass, ClassUtils.NO_ARGS, this.getClass());
                BeanUtils.populateWithoutFail(model, this.properties, false);
                return model;
            }
            catch (Exception e) {
                throw new ServiceException(CoreMessages.failedToCreate(this.modelClass), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Class<Model> getModelClass() throws ServiceException {
        try {
            return ClassUtils.getClass((String)this.modelClass);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException(CoreMessages.cannotLoadFromClasspath(this.modelClass), (Throwable)e);
        }
    }
}

