/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.mule.api.MuleMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutboundAttachmentsMap
implements Map<String, DataHandler> {
    private MuleMessage message;

    public OutboundAttachmentsMap(MuleMessage message) {
        this.message = message;
    }

    @Override
    public int size() {
        return this.message.getOutboundAttachmentNames().size();
    }

    @Override
    public boolean isEmpty() {
        return this.message.getOutboundAttachmentNames().size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.message.getOutboundAttachmentNames().contains(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public DataHandler get(Object key) {
        return this.message.getOutboundAttachment(key.toString());
    }

    @Override
    public DataHandler put(String key, DataHandler value) {
        try {
            this.message.addOutboundAttachment(key, value);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DataHandler put(String key, Object value, String contentType) {
        try {
            this.message.addOutboundAttachment(key, value, contentType);
            return this.get(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataHandler remove(Object key) {
        DataHandler attachment = this.message.getOutboundAttachment(key.toString());
        try {
            this.message.removeOutboundAttachment(key.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attachment;
    }

    @Override
    public void putAll(Map<? extends String, ? extends DataHandler> map) {
        for (Map.Entry<? extends String, ? extends DataHandler> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public Set<String> keySet() {
        return this.message.getOutboundAttachmentNames();
    }

    @Override
    public Collection<DataHandler> values() {
        return this.getAttachments().values();
    }

    @Override
    public Set<Map.Entry<String, DataHandler>> entrySet() {
        return this.getAttachments().entrySet();
    }

    private Map<String, DataHandler> getAttachments() {
        HashMap<String, DataHandler> props = new HashMap<String, DataHandler>();
        for (String s : this.message.getOutboundAttachmentNames()) {
            props.put(s, this.message.getOutboundAttachment(s));
        }
        return props;
    }
}

